<?php
	/*	
	*	Goodlayers Framework File
	*	---------------------------------------------------------------------
	*	This file contains the homepage loading button in page option area
	*	---------------------------------------------------------------------
	*/
	
	add_action('add_meta_boxes', 'totalbusiness_init_demo_page_option');
	if( !function_exists('totalbusiness_init_demo_page_option') ){
		function totalbusiness_init_demo_page_option(){
			add_meta_box( 'demo-page-option', 
				esc_html__('Load Demo Page', 'totalbusiness'), 
				'totalbusiness_create_demo_page_option',
				'page',
				'side',
				'default'
			);
		}
	}
	
	if( !function_exists('totalbusiness_create_demo_page_option') ){
		function totalbusiness_create_demo_page_option(){
			global $post;
		
			$buttons = array(
				'homepage-1' => esc_html__('Homepage Wood', 'totalbusiness'),
				'homepage-2' => esc_html__('Homepage Plastic', 'totalbusiness'),
				'homepage-3' => esc_html__('Homepage Steel', 'totalbusiness'),
				'homepage-4' => esc_html__('Homepage Creative 1', 'totalbusiness'),
				'homepage-5' => esc_html__('Homepage Creative 2', 'totalbusiness'),
				'homepage-6' => esc_html__('Homepage Creative 3', 'totalbusiness'),
				'homepage-7' => esc_html__('Homepage Coffee', 'totalbusiness'),
				'homepage-8' => esc_html__('Homepage Cafe', 'totalbusiness'),
				'homepage-9' => esc_html__('Homepage Wedding', 'totalbusiness'),
				'about-1' => esc_html__('About Us 1', 'totalbusiness'),
				'about-2' => esc_html__('About Us 2', 'totalbusiness'),
				'about-3' => esc_html__('About Us 3', 'totalbusiness'),
				'service-1' => esc_html__('Service 1', 'totalbusiness'),
				'service-2' => esc_html__('Service 2', 'totalbusiness'),
				'q-a' => esc_html__('Q&A', 'totalbusiness'),
				'personnel' => esc_html__('Personnel', 'totalbusiness'),
				'contact-1' => esc_html__('Contact 1', 'totalbusiness'),
				'contact-2' => esc_html__('Contact 2', 'totalbusiness')
			);
			
			echo '<div id="totalbusiness-load-demo-wrapper" data-ajax="' . esc_url(AJAX_URL) . '" data-id="' . $post->ID . '" data-action="load_demo_pagebuilder">';
			echo '<em>';
			echo esc_html__('*This option allow you to set page item to following pages with one click. Note that to use this option will replace all your current page item setting in this page and <strong>This Can\'t Be Undone</strong>. ( Images are not included. )', 'totalbusiness');
			echo '</em><div class="clear"></div>';
			echo '<select name="totalbusiness-load-demo-page" >';
			foreach( $buttons as $button_slug => $button_title ){
				echo '<option type="button"  value="' . $button_slug . '" >' . $button_title . '</option>';
			}
			echo '</select>';
			echo '<input type="button" value="' . esc_html__('Submit', 'totalbusiness') . '" />';
			echo '</div>';

		}
	}
	
	add_action('wp_ajax_load_demo_pagebuilder', 'totalbusiness_load_demo_pagebuilder');
	if( !function_exists('totalbusiness_load_demo_pagebuilder') ){
		function totalbusiness_load_demo_pagebuilder(){
			$default_data = array(
				'homepage-1' => array(
					'above-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Full Size Wrapper","type":"full-size-wrapper","items":[{"item-type":"item","item-builder-title":"Master Slider","type":"master-slider","option":{"page-item-id":"","id":"11","margin-bottom":"0px"}}],"option":{"page-item-id":"","skin":"no-skin","background":"#ffffff","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"0px","padding-bottom":"0px"}}]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5370","icon":"","title":"Commodo Fringilla Nibh","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5371","icon":"","title":"Mattis Sollicitudin","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5373","icon":"","title":"Ultricies Purus Tristique","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5372","icon":"","title":"Tristique Egestas Dolor","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5374","icon":"","title":"Amet Tristique Magna","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5375","icon":"","title":"Ornare Cras Ultricies","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"20px"}}],"option":{},"size":"1/3"}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"20px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Stunning Text","type":"stunning-text","option":{"page-item-id":"","style":"left","title":"It\'s The Best WordPress Theme.","caption":"This theme comes with many awesome features and it suits to any kind of businesses. You will love it!","button-text":"Learn More","button-link":"#","button2-text":"Buy Now!","button2-link":"","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"5379","background-mobile":"","background-speed":"0.05","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"totalbusiness-skin-dark-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"110px","padding-bottom":"80px"}},{"item-type":"wrapper","item-builder-title":"Full Size Wrapper","type":"full-size-wrapper","items":[{"item-type":"item","item-builder-title":"Portfolio","type":"portfolio","option":{"page-item-id":"","title-type":"center","title-size":"medium","title":"Featured Works","caption":"","right-text":"View All Works","right-text-link":"#","category":"","tag":"","portfolio-style":"modern-portfolio-no-space","num-fetch":"6","num-excerpt":"20","portfolio-size":"1/3","portfolio-layout":"fitRows","portfolio-filter":"disable","thumbnail-size":"blog-grid","thumbnail-size-featured":"thumbnail","orderby":"date","order":"desc","pagination":"disable","margin-bottom":"0px"}}],"option":{"page-item-id":"","skin":"totalbusiness-skin-dark-skin","background":"#2f2f2f","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"45px","padding-bottom":"0px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"About Us","type":"about-us","option":{"page-item-id":"","style":"plain","caption":"","title":"About Us","content":"<p>Donec ullamcorper nulla non metus auctor fringilla. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec id elit non mi porta gravida at eget metus. Donec id elit non mi porta gravida at eget metus.</p>","read-more-text":"Read More","read-more-link":"#","margin-bottom":"20px"}}],"option":{},"size":"1/2"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Advanced Technologies","percent":"80","size":"small","icon":"","text-color":"#3a3a3a","background-color":"#e9e9e9","progress-color":"#36bddb","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Production Capacity","percent":"95","size":"small","icon":"","text-color":"#3a3a3a","background-color":"#e9e9e9","progress-color":"#36bddb","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Utilization Rate","percent":"70","size":"small","icon":"","text-color":"#3a3a3a","background-color":"#e9e9e9","progress-color":"#36bddb","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Customer Satisfaction","percent":"100","size":"small","icon":"","text-color":"#3a3a3a","background-color":"#e9e9e9","progress-color":"#36bddb","margin-bottom":"20px"}}],"option":{},"size":"1/2"}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"75px","padding-bottom":"50px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"350","caption":"Employees","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"12000","caption":"Square Feet","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"2400","caption":"Happy Clients","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"350","caption":"Employees","margin-bottom":"20px"}}],"option":{},"size":"1/4"}],"option":{"page-item-id":"","type":"image","background":"5387","background-mobile":"","background-speed":"0.1","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"100px","padding-bottom":"70px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"left","title-size":"large","title":"Our Vision","caption":"","right-text":"Read All News","right-text-link":"","content":"<p>Cras justo odio, dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec id elit non mi porta gravida at eget metus. Donec id elit non mi porta gravida at eget metus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Curabitur blandit tempus porttitor. Donec ullamcorper nulla non metus auctor fringilla. Nulla vitae elit libero, a pharetra augue. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Nullam id dolor id nibh ultricies vehicula ut id elit.</p><p><a href=|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/wood-vision-sig.png|gq2|><img class=|gq2|alignnone size-full wp-image-5420|gq2| src=|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/wood-vision-sig.png|gq2| alt=|gq2|wood-vision-sig|gq2| width=|gq2|197|gq2| height=|gq2|34|gq2| /></a></p><p><strong>Paul Heizenberg</strong><br /> CEO of Total Factory</p>","margin-bottom":"20px"}}],"option":{},"size":"1/2"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[],"option":{},"size":"1/2"}],"option":{"page-item-id":"","type":"image","background":"5390","background-mobile":"","background-speed":"0","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"totalbusiness-skin-dark-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"80px","padding-bottom":"65px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Blog","type":"blog","option":{"page-item-id":"","title-type":"left","title-size":"medium","title":"Recent News","caption":"","right-text":"Read All News","right-text-link":"#","category":"","tag":"","num-excerpt":"25","num-fetch":"6","blog-style":"blog-1-3","blog-layout":"carousel","thumbnail-size":"small-grid-size","orderby":"date","order":"desc","offset":"","pagination":"disable","enable-sticky":"disable","margin-bottom":"0px"}}],"option":{"page-item-id":"","background-type":"color","background":"#f7f7f7","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"10px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[],"option":{},"size":"1/5"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[{"item-type":"item","item-builder-title":"Testimonial","type":"testimonial","option":{"page-item-id":"","testimonial":"[{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|John Smoth|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Furniture Fact|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Etiam porta sem malesuada magna mollis euismod. Maecenas faucibus mollis interdum. Donec ullamcorper nulla non metus auctor fringilla. Nullam id dolor id nibh ultricies vehicula ut id elit. Lorem ipsum dolor sit amet, consectetur.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Paul Johnson|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Apple|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Nulla vitae elit libero, a pharetra augue. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Donec id elit non mi porta gravida at eget metus. Maecenas faucibus mollis interdum.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Alan Smith|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Wooden Corp.|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Nullam quis risus eget urna mollis ornare vel eu leo. Aenean lacinia bibendum nulla sed consectetur. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit.|gq2|}]","title-type":"center","title-size":"medium","title":"Testimonial","caption":"","testimonial-columns":"1","testimonial-type":"carousel","testimonial-style":"large plain-style","margin-bottom":"20px"}}],"option":{},"size":"2/3"}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"20px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Banner","type":"banner","option":{"page-item-id":"","slider":"[[5404,5405,5406,5407,5400],{|gq2|5390|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/wood-about-bg-150x150.jpg|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:150},|gq2|5396|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-1.png|gq2|,|gq2|width|gq2|:147,|gq2|height|gq2|:40},|gq2|5397|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-2-150x26.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:26},|gq2|5398|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-3-150x40.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:40},|gq2|5399|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-4.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:46},|gq2|5400|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-5.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:59},|gq2|5404|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-1.png|gq2|,|gq2|width|gq2|:147,|gq2|height|gq2|:58},|gq2|5405|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-2-150x59.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:59},|gq2|5406|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-3-150x58.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:58},|gq2|5407|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-4.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:59}}]","thumbnail-size":"full","banner-columns":"5","margin-bottom":"20px"}}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"top","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"50px","padding-bottom":"15px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'homepage-2' => array(
					'above-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Full Size Wrapper","type":"full-size-wrapper","items":[{"item-type":"item","item-builder-title":"Master Slider","type":"master-slider","option":{"page-item-id":"","id":"1","margin-bottom":"0px"}}],"option":{"page-item-id":"","skin":"no-skin","background":"#ffffff","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"0px","padding-bottom":"0px"}}]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Stunning Text","type":"stunning-text","option":{"page-item-id":"","style":"left","title":"It\'s The Best WordPress Theme.","caption":"This theme comes with many awesome features and it suits to any kind of businesses. You will love it!","button-text":"Learn More","button-link":"#","button2-text":"Buy Now!","button2-link":"","margin-bottom":"20px"}}],"option":{"page-item-id":"","background-type":"color","background":"#eb4c4c","skin":"totalbusiness-skin-stunning-text","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"60px","padding-bottom":"40px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5692","icon":"","title":"Commodo Fringilla Nibh","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5693","icon":"","title":"Mattis Sollicitudin","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5694","icon":"","title":"Ultricies Purus Tristique","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"20px"}}],"option":{},"size":"1/3"}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"50px","padding-bottom":"30px"}},{"item-type":"wrapper","item-builder-title":"Full Size Wrapper","type":"full-size-wrapper","items":[{"item-type":"item","item-builder-title":"Portfolio","type":"portfolio","option":{"page-item-id":"","title-type":"left","title-size":"medium","title":"Featured Works","caption":"","right-text":"View All Works","right-text-link":"#","category":"","tag":"","portfolio-style":"modern-portfolio-no-space","num-fetch":"6","num-excerpt":"20","portfolio-size":"1/3","portfolio-layout":"carousel","portfolio-filter":"disable","thumbnail-size":"blog-grid","thumbnail-size-featured":"thumbnail","orderby":"date","order":"desc","pagination":"disable","margin-bottom":"0px"}}],"option":{"page-item-id":"","skin":"no-skin","background":"#f5f5f5","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"45px","padding-bottom":"0px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"List With Icon","type":"icon-with-list","option":{"page-item-id":"","icon-with-list":"[{|gq2|gdl-tab-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/plasticfactory/wp-content/uploads/2015/09/icon-list-1.png|gq2|,|gq2|gdl-tab-image|gq2|:|gq2|5529|gq2|,|gq2|gdl-tab-icon|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Bibendum Etiam Risus Adipiscing|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Donec sed odio dui. Maecenas sed diam eget risus varius blandit sit amet non magna. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Cum sociis natoque penatibus et magnis dis parturient montes|gq2|},{|gq2|gdl-tab-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/plasticfactory/wp-content/uploads/2015/09/icon-list-2.png|gq2|,|gq2|gdl-tab-image|gq2|:|gq2|5530|gq2|,|gq2|gdl-tab-icon|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Ornare Sem Purus|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Donec sed odio dui. Maecenas sed diam eget risus varius blandit sit amet non magna. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Cum sociis natoque penatibus et magnis dis parturient montes|gq2|},{|gq2|gdl-tab-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/plasticfactory/wp-content/uploads/2015/09/icon-list-3.png|gq2|,|gq2|gdl-tab-image|gq2|:|gq2|5531|gq2|,|gq2|gdl-tab-icon|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Venenatis Vulputate Porta|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Donec sed odio dui. Maecenas sed diam eget risus varius blandit sit amet non magna. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Cum sociis natoque penatibus et magnis dis parturient montes|gq2|}]","title-type":"none","title-size":"medium","title":"","caption":"","align":"right","margin-bottom":"0px"}}],"option":{},"size":"1/2"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"List With Icon","type":"icon-with-list","option":{"page-item-id":"","icon-with-list":"[{|gq2|gdl-tab-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/plasticfactory/wp-content/uploads/2015/09/icon-list-5.png|gq2|,|gq2|gdl-tab-image|gq2|:|gq2|5533|gq2|,|gq2|gdl-tab-icon|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Amet Ullamcorper Quam Justo|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Donec sed odio dui. Maecenas sed diam eget risus varius blandit sit amet non magna. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Cum sociis natoque penatibus et magnis dis parturient montes|gq2|},{|gq2|gdl-tab-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/plasticfactory/wp-content/uploads/2015/09/icon-list-4.png|gq2|,|gq2|gdl-tab-image|gq2|:|gq2|5532|gq2|,|gq2|gdl-tab-icon|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Inceptos Euismod Ultricies|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Donec sed odio dui. Maecenas sed diam eget risus varius blandit sit amet non magna. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Cum sociis natoque penatibus et magnis dis parturient montes|gq2|},{|gq2|gdl-tab-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/plasticfactory/wp-content/uploads/2015/09/icon-list-6.png|gq2|,|gq2|gdl-tab-image|gq2|:|gq2|5534|gq2|,|gq2|gdl-tab-icon|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Dolor Malesuada Tortor|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Donec sed odio dui. Maecenas sed diam eget risus varius blandit sit amet non magna. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Cum sociis natoque penatibus et magnis dis parturient montes|gq2|}]","title-type":"none","title-size":"medium","title":"","caption":"","align":"left","margin-bottom":"0px"}}],"option":{},"size":"1/2"},{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","title-size":"medium","title":"","caption":"","right-text":"Read All News","right-text-link":"","content":"<p style=|gq2|text-align: center;|gq2|>[gdlr_button href=|gq2|#|gq2| target=|gq2|_self|gq2| size=|gq2|medium|gq2| background=|gq2|#eb4c4c|gq2| color=|gq2|#ffffff|gq2|]Learn More[/gdlr_button]<br /> [gdlr_button href=|gq2|#|gq2| target=|gq2|_self|gq2| size=|gq2|medium|gq2| background=|gq2|#eb4c4c|gq2| color=|gq2|#ffffff|gq2|]Buy Now![/gdlr_button]</p>","margin-bottom":"20px"}}],"option":{"page-item-id":"","background-type":"color","background":"#f7f7f7","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"30px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#eb4c4c","caption-color":"#363636","title":"350","caption":"Employees","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#eb4c4c","caption-color":"#363636","title":"12000","caption":"Square Feet","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#eb4c4c","caption-color":"#363636","title":"2400","caption":"Happy Clients","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#eb4c4c","caption-color":"#363636","title":"350","caption":"Employees","margin-bottom":"20px"}}],"option":{},"size":"1/4"}],"option":{"page-item-id":"","type":"image","background":"","background-mobile":"","background-speed":"0.1","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"totalbusiness-skin-light-grey","show-section":"gdlr-show-all","border":"both","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"40px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","title-size":"medium","title":"","caption":"","right-text":"Read All News","right-text-link":"","content":"<div style=|gq2|margin-top: -5px; margin-right: 30px;|gq2|><img class=|gq2|size-full wp-image-5703 alignright|gq2| src=|gq2|http://demo.goodlayers.com/totalbusiness/plasticfactory/wp-content/uploads/2015/09/plastic-about-1.png|gq2| alt=|gq2|plastic-about-1|gq2| width=|gq2|179|gq2| height=|gq2|179|gq2| /></div>","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"About Us","type":"about-us","option":{"page-item-id":"","style":"plain","caption":"","title":"About Us","content":"<p>Donec ullamcorper nulla non metus auctor fringilla. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Cum sociis natoque penatibus et magnis dis parturient.</p>","read-more-text":"Read More","read-more-link":"#","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Advanced Technologies","percent":"80","size":"small","icon":"","text-color":"#3a3a3a","background-color":"#e9e9e9","progress-color":"#eb4c4c","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Production Capacity","percent":"95","size":"small","icon":"","text-color":"#3a3a3a","background-color":"#e9e9e9","progress-color":"#eb4c4c","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Utilization Rate","percent":"70","size":"small","icon":"","text-color":"#3a3a3a","background-color":"#e9e9e9","progress-color":"#eb4c4c","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Customer Satisfaction","percent":"100","size":"small","icon":"","text-color":"#3a3a3a","background-color":"#e9e9e9","progress-color":"#eb4c4c","margin-bottom":"20px"}}],"option":{},"size":"1/3"}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"75px","padding-bottom":"50px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[],"option":{},"size":"1/5"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"center","title-size":"large","title":"Our Vision","caption":"","right-text":"Read All News","right-text-link":"","content":"<p style=|gq2|text-align: center;|gq2|>Cras justo odio, dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec id elit non mi porta gravida at eget metus. Donec id elit non mi porta gravida at eget metus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Curabitur blandit tempus porttitor. Donec ullamcorper nulla non metus auctor fringilla. Nulla vitae elit libero, a pharetra augue. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Nullam id dolor id nibh ultricies vehicula ut id elit.</p><p style=|gq2|text-align: center;|gq2|><a href=|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/wood-vision-sig.png|gq2|><img class=|gq2|alignnone size-full wp-image-5420|gq2| src=|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/wood-vision-sig.png|gq2| alt=|gq2|wood-vision-sig|gq2| width=|gq2|197|gq2| height=|gq2|34|gq2| /></a></p><p style=|gq2|text-align: center;|gq2|><strong>Paul Heizenberg</strong><br /> CEO of Total Factory</p>","margin-bottom":"20px"}}],"option":{},"size":"3/5"}],"option":{"page-item-id":"","type":"image","background":"5713","background-mobile":"","background-speed":"0","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"totalbusiness-skin-dark-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"80px","padding-bottom":"50px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Title","type":"title","option":{"page-item-id":"","title-type":"left","title-size":"small","title":"Video Tour","caption":"","right-text":"Read All News","right-text-link":"","margin-bottom":"40px"}},{"item-type":"item","item-builder-title":"Video","type":"video","option":{"page-item-id":"","url":"https://vimeo.com/73356913","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[{"item-type":"item","item-builder-title":"Testimonial","type":"testimonial","option":{"page-item-id":"","testimonial":"[{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|John Smoth|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Furniture Fact|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Etiam porta sem malesuada magna mollis euismod. Maecenas faucibus mollis interdum. Donec ullamcorper nulla non metus auctor fringilla. Nullam id dolor id nibh ultricies vehicula ut id elit. Lorem ipsum.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Paul Johnson|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Apple|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Nulla vitae elit libero, a pharetra augue. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Donec id elit non mi porta gravida at eget metus. Maecenas faucibus mollis interdum.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Alan Smith|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Wooden Corp.|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Nullam quis risus eget urna mollis ornare vel eu leo. Aenean lacinia bibe ndum nulla sed consectetur. Duis mollis, est non commodo luctus, nisi erat.|gq2|}]","title-type":"left","title-size":"small","title":"Testimonial","caption":"","testimonial-columns":"1","testimonial-type":"carousel","testimonial-style":"totalbusiness-left plain-style","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[{"item-type":"item","item-builder-title":"Blog","type":"blog","option":{"page-item-id":"","title-type":"left","title-size":"small","title":"Recent News","caption":"","right-text":"Read All News","right-text-link":"#","category":"","tag":"","num-excerpt":"25","num-fetch":"3","blog-style":"blog-widget-1-1","blog-layout":"carousel","thumbnail-size":"round-personnel-size","orderby":"date","order":"desc","offset":"","pagination":"disable","enable-sticky":"disable","margin-bottom":"0px"}}],"option":{},"size":"1/3"}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"20px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Banner","type":"banner","option":{"page-item-id":"","slider":"[[5404,5405,5406,5407,5400],{|gq2|5390|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/wood-about-bg-150x150.jpg|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:150},|gq2|5396|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-1.png|gq2|,|gq2|width|gq2|:147,|gq2|height|gq2|:40},|gq2|5397|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-2-150x26.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:26},|gq2|5398|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-3-150x40.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:40},|gq2|5399|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-4.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:46},|gq2|5400|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-5.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:59},|gq2|5404|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-1.png|gq2|,|gq2|width|gq2|:147,|gq2|height|gq2|:58},|gq2|5405|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-2-150x59.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:59},|gq2|5406|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-3-150x58.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:58},|gq2|5407|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-4.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:59}}]","thumbnail-size":"full","banner-columns":"5","margin-bottom":"20px"}}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"top","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"50px","padding-bottom":"15px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'homepage-3' => array(
					'above-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Full Size Wrapper","type":"full-size-wrapper","items":[{"item-type":"item","item-builder-title":"Master Slider","type":"master-slider","option":{"page-item-id":"","id":"1","margin-bottom":"0px"}}],"option":{"page-item-id":"","skin":"no-skin","background":"#ffffff","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"0px","padding-bottom":"0px"}}]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5681","icon":"","title":"Flanging & Advanced Pressing","style":"type-3","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"#","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5682","icon":"","title":"Metal Sheet Cutting","style":"type-3","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"#","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5683","icon":"","title":"Machine Welding","style":"type-3","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"#","margin-bottom":"20px"}}],"option":{},"size":"1/3"}],"option":{"page-item-id":"","background-type":"","background":"#ffffff","skin":"","show-section":"","border":"","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"60px","padding-bottom":"40px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"About Us","type":"about-us","option":{"page-item-id":"","style":"title-left","caption":"","title":"Little Story<br/>Abouts Us","content":"<p><strong>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. </strong></p><p>Cras mattis consecte. Curabitur blandit tempus porttitor. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Sed posuere consectetur est at lobortis. Donec sed odio dui. Donec sed odio dui. Maecenas faucibus mollis interdum. Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Aenean lacinia bibendum nulla sed consectetur. Maecenas sed diam eget risus varius blandit sit amet non magna.</p><p>[gdlr_space height=|gq2|30px|gq2|]</p><p>[gdlr_button href=|gq2|#|gq2| target=|gq2|_self|gq2| size=|gq2|medium|gq2| background=|gq2|#f99529|gq2| color=|gq2|#ffffff|gq2|]Learn More[/gdlr_button]</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"20px"}}],"option":{"page-item-id":"","background-type":"color","background":"#f5f5f5","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"5px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5370","icon":"","title":"Commodo Fringilla Nibh","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"25px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5371","icon":"","title":"Mattis Sollicitudin","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"25px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5373","icon":"","title":"Ultricies Purus Tristique","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"25px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5372","icon":"","title":"Tristique Egestas Dolor","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"25px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5374","icon":"","title":"Amet Tristique Magna","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"25px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5375","icon":"","title":"Ornare Cras Ultricies","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"25px"}}],"option":{},"size":"1/3"}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"75px","padding-bottom":"20px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Portfolio","type":"portfolio","option":{"page-item-id":"","title-type":"left","title-size":"medium","title":"Featured Works","caption":"","right-text":"View All Works","right-text-link":"#","category":"","tag":"","portfolio-style":"modern-portfolio","num-fetch":"5","num-excerpt":"20","portfolio-size":"1/3","portfolio-layout":"masonry-style-1","portfolio-filter":"disable","thumbnail-size":"portfolio-half","thumbnail-size-featured":"portfolio-featured","orderby":"date","order":"desc","pagination":"disable","margin-bottom":"0px"}}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"top","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"60px","padding-bottom":"40px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Stunning Text","type":"stunning-text","option":{"page-item-id":"","style":"left","title":"It\'s The Best WordPress Theme.","caption":"This theme comes with many awesome features and it suits to any kind of businesses. You will love it!","button-text":"Learn More","button-link":"#","button2-text":"Buy Now!","button2-link":"","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"5722","background-mobile":"","background-speed":"0.05","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"totalbusiness-skin-dark-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"130px","padding-bottom":"100px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Personnel","type":"personnel","option":{"page-item-id":"","personnel":"[{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/steelfactory/wp-content/uploads/2015/07/personnel-1.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|5440|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Paul Henberg|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Chief Executive Officer|gq2|,|gq2|gdl-tab-content|gq2|:|gq2||gq2|,|gq2|gdl-tab-social-list|gq2|:|gq2|[gdlr_icon type=|gq6|fa-facebook|gq6| size=|gq6|15px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-twitter|gq6| size=|gq6|15px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-linkedin|gq6| size=|gq6|15px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-skype|gq6| size=|gq6|15px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-pinterest|gq6| size=|gq6|15px|gq6| color=|gq6|#999999|gq6|] |g2n|[gdlr_space height=|gq6|35px|gq6|]|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/steelfactory/wp-content/uploads/2015/07/personnel-3.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|5444|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Anna Sui|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Investor Relation|gq2|,|gq2|gdl-tab-content|gq2|:|gq2||gq2|,|gq2|gdl-tab-social-list|gq2|:|gq2|[gdlr_icon type=|gq6|fa-facebook|gq6| size=|gq6|15px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-twitter|gq6| size=|gq6|15px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-linkedin|gq6| size=|gq6|15px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-skype|gq6| size=|gq6|15px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-pinterest|gq6| size=|gq6|15px|gq6| color=|gq6|#999999|gq6|] |g2n|[gdlr_space height=|gq6|35px|gq6|]|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/steelfactory/wp-content/uploads/2015/09/personnel-8.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|5696|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|John Smith|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Chief Financial Officer|gq2|,|gq2|gdl-tab-content|gq2|:|gq2||gq2|,|gq2|gdl-tab-social-list|gq2|:|gq2|[gdlr_icon type=|gq6|fa-facebook|gq6| size=|gq6|15px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-twitter|gq6| size=|gq6|15px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-linkedin|gq6| size=|gq6|15px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-skype|gq6| size=|gq6|15px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-pinterest|gq6| size=|gq6|15px|gq6| color=|gq6|#999999|gq6|] |g2n|[gdlr_space height=|gq6|35px|gq6|]|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/steelfactory/wp-content/uploads/2015/09/personnel-7.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|5695|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Paul Smith|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Senior Mechanic|gq2|,|gq2|gdl-tab-content|gq2|:|gq2||gq2|,|gq2|gdl-tab-social-list|gq2|:|gq2|[gdlr_icon type=|gq6|fa-facebook|gq6| size=|gq6|15px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-twitter|gq6| size=|gq6|15px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-linkedin|gq6| size=|gq6|15px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-skype|gq6| size=|gq6|15px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-pinterest|gq6| size=|gq6|15px|gq6| color=|gq6|#999999|gq6|] |g2n|[gdlr_space height=|gq6|35px|gq6|]|gq2|}]","title-type":"center","title-size":"medium","title":"Meet The Team","caption":"","personnel-columns":"4","personnel-type":"static","personnel-style":"totalbusiness-left plain-style","thumbnail-size":"blog-grid","margin-bottom":"20px"}}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"55px","padding-bottom":"10px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Banner","type":"banner","option":{"page-item-id":"","slider":"[[5404,5405,5406,5407,5400],{|gq2|5390|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/wood-about-bg-150x150.jpg|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:150},|gq2|5396|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-1.png|gq2|,|gq2|width|gq2|:147,|gq2|height|gq2|:40},|gq2|5397|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-2-150x26.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:26},|gq2|5398|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-3-150x40.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:40},|gq2|5399|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-4.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:46},|gq2|5400|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-5.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:59},|gq2|5404|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-1.png|gq2|,|gq2|width|gq2|:147,|gq2|height|gq2|:58},|gq2|5405|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-2-150x59.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:59},|gq2|5406|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-3-150x58.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:58},|gq2|5407|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-4.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:59}}]","thumbnail-size":"full","banner-columns":"5","margin-bottom":"20px"}}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"top","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"50px","padding-bottom":"15px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'homepage-4' => array(
					'above-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Full Size Wrapper","type":"full-size-wrapper","items":[{"item-type":"item","item-builder-title":"Master Slider","type":"master-slider","option":{"page-item-id":"","id":"1","margin-bottom":"0px"}}],"option":{"page-item-id":"","skin":"no-skin","background":"#ffffff","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"0px","padding-bottom":"0px"}}]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"About Us","type":"about-us","option":{"page-item-id":"","style":"plain","caption":"","title":"About Us","content":"<p>Donec ullamcorper nulla non metus auctor fringilla. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec id elit non mi porta gravida at eget metus. Donec id elit non mi porta gravida at eget metus.</p>","read-more-text":"Read More","read-more-link":"#","margin-bottom":"20px"}}],"option":{},"size":"1/2"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Advanced Technologies","percent":"80","size":"small","icon":"","text-color":"#3a3a3a","background-color":"#e9e9e9","progress-color":"#36bddb","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Production Capacity","percent":"95","size":"small","icon":"","text-color":"#3a3a3a","background-color":"#e9e9e9","progress-color":"#36bddb","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Utilization Rate","percent":"70","size":"small","icon":"","text-color":"#3a3a3a","background-color":"#e9e9e9","progress-color":"#36bddb","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Customer Satisfaction","percent":"100","size":"small","icon":"","text-color":"#3a3a3a","background-color":"#e9e9e9","progress-color":"#36bddb","margin-bottom":"20px"}}],"option":{},"size":"1/2"}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"75px","padding-bottom":"50px"}},{"item-type":"wrapper","item-builder-title":"Full Size Wrapper","type":"full-size-wrapper","items":[{"item-type":"item","item-builder-title":"Portfolio","type":"portfolio","option":{"page-item-id":"","title-type":"none","title-size":"medium","title":"Featured Works","caption":"","right-text":"View All Works","right-text-link":"#","category":"","tag":"","portfolio-style":"modern-portfolio-no-space","num-fetch":"9","num-excerpt":"20","portfolio-size":"1/3","portfolio-layout":"fitRows","portfolio-filter":"disable","thumbnail-size":"blog-grid","thumbnail-size-featured":"thumbnail","orderby":"date","order":"desc","pagination":"disable","margin-bottom":"0px"}}],"option":{"page-item-id":"","skin":"totalbusiness-skin-dark-skin","background":"#2f2f2f","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"0px","padding-bottom":"0px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"350","caption":"Employees","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#36bddb","caption-color":"#ffffff","title":"12000","caption":"Square Feet","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"2400","caption":"Happy Clients","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#36bddb","caption-color":"#ffffff","title":"350","caption":"Employees","margin-bottom":"20px"}}],"option":{},"size":"1/4"}],"option":{"page-item-id":"","background-type":"color","background":"#2a2a2a","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"97px","padding-bottom":"77px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5686","icon":"","title":"Commodo Fringilla Nibh","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"43px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5687","icon":"","title":"Mattis Sollicitudin","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"43px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5688","icon":"","title":"Ultricies Purus Tristique","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"43px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5689","icon":"","title":"Tristique Egestas Dolor","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"43px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5690","icon":"","title":"Amet Tristique Magna","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"43px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5691","icon":"","title":"Ornare Cras Ultricies","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"43px"}}],"option":{},"size":"1/3"}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"25px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Stunning Text","type":"stunning-text","option":{"page-item-id":"","style":"left","title":"It\'s The Best WordPress Theme.","caption":"This theme comes with many awesome features and it suits to any kind of businesses. You will love it!","button-text":"Learn More","button-link":"#","button2-text":"Buy Now!","button2-link":"","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"5699","background-mobile":"","background-speed":"0.05","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"totalbusiness-skin-dark-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"240px","padding-bottom":"65px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Banner","type":"banner","option":{"page-item-id":"","slider":"[[5404,5405,5406,5407,5400],{|gq2|5390|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/wood-about-bg-150x150.jpg|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:150},|gq2|5396|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-1.png|gq2|,|gq2|width|gq2|:147,|gq2|height|gq2|:40},|gq2|5397|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-2-150x26.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:26},|gq2|5398|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-3-150x40.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:40},|gq2|5399|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-4.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:46},|gq2|5400|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-5.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:59},|gq2|5404|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-1.png|gq2|,|gq2|width|gq2|:147,|gq2|height|gq2|:58},|gq2|5405|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-2-150x59.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:59},|gq2|5406|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-3-150x58.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:58},|gq2|5407|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-4.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:59}}]","thumbnail-size":"full","banner-columns":"5","margin-bottom":"20px"}}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"50px","padding-bottom":"15px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'homepage-5' => array(
					'above-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Full Size Wrapper","type":"full-size-wrapper","items":[{"item-type":"item","item-builder-title":"Master Slider","type":"master-slider","option":{"page-item-id":"","id":"1","margin-bottom":"0px"}}],"option":{"page-item-id":"","skin":"no-skin","background":"#ffffff","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"0px","padding-bottom":"0px"}}]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Portfolio","type":"portfolio","option":{"page-item-id":"","title-type":"none","title-size":"medium","title":"Featured Works","caption":"","right-text":"View All Works","right-text-link":"#","category":"all","tag":"","portfolio-style":"modern-portfolio","num-fetch":"11","num-excerpt":"20","portfolio-size":"1/3","portfolio-layout":"masonry-style-2","portfolio-filter":"enable","thumbnail-size":"portfolio-half","thumbnail-size-featured":"portfolio-featured","orderby":"date","order":"desc","pagination":"disable","margin-bottom":"0px"}}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"60px","padding-bottom":"40px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#343434","caption-color":"#343434","title":"350","caption":"Employees","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#36d8a9","caption-color":"#343434","title":"12000","caption":"Square Feet","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#343434","caption-color":"#343434","title":"2400","caption":"Happy Clients","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#36d8a9","caption-color":"#343434","title":"350","caption":"Employees","margin-bottom":"20px"}}],"option":{},"size":"1/4"}],"option":{"page-item-id":"","background-type":"color","background":"#f7f7f7","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"97px","padding-bottom":"77px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'homepage-6' => array(
					'above-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Full Size Wrapper","type":"full-size-wrapper","items":[{"item-type":"item","item-builder-title":"Master Slider","type":"master-slider","option":{"page-item-id":"","id":"1","margin-bottom":"0px"}}],"option":{"page-item-id":"","skin":"no-skin","background":"#ffffff","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"0px","padding-bottom":"0px"}}]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5899","icon":"","title":"Commodo Fringilla Nibh","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"30px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5900","icon":"","title":"Mattis Sollicitudin","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"30px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5901","icon":"","title":"Ultricies Purus Tristique","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"30px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5902","icon":"","title":"Tristique Egestas Dolor","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"30px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5903","icon":"","title":"Amet Tristique Magna","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"30px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5904","icon":"","title":"Ornare Cras Ultricies","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"30px"}}],"option":{},"size":"1/3"}],"option":{"page-item-id":"","background-type":"color","background":"#2c2c2c","skin":"totalbusiness-skin-dark-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"15px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Portfolio","type":"portfolio","option":{"page-item-id":"","title-type":"none","title-size":"medium","title":"Featured Works","caption":"","right-text":"View All Works","right-text-link":"#","category":"all","tag":"","portfolio-style":"modern-portfolio","num-fetch":"9","num-excerpt":"20","portfolio-size":"1/3","portfolio-layout":"fitRows","portfolio-filter":"enable","thumbnail-size":"portfolio-half","thumbnail-size-featured":"thumbnail","orderby":"date","order":"desc","pagination":"disable","margin-bottom":"0px"}}],"option":{"page-item-id":"","background-type":"","background":"#ffffff","skin":"","show-section":"","border":"","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"60px","padding-bottom":"40px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Stunning Text","type":"stunning-text","option":{"page-item-id":"","style":"left","title":"It\'s The Best WordPress Theme.","caption":"This theme comes with many awesome features and it suits to any kind of businesses. You will love it!","button-text":"Learn More","button-link":"#","button2-text":"Buy Now!","button2-link":"","margin-bottom":"20px"}}],"option":{"page-item-id":"","background-type":"color","background":"#2c2c2c","skin":"totalbusiness-skin-dark-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"100px","padding-bottom":"75px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Advanced Technologies","percent":"80","size":"small","icon":"","text-color":"#3a3a3a","background-color":"#e9e9e9","progress-color":"#36d8a9","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Production Capacity","percent":"95","size":"small","icon":"","text-color":"#3a3a3a","background-color":"#e9e9e9","progress-color":"#36d8a9","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Utilization Rate","percent":"70","size":"small","icon":"","text-color":"#3a3a3a","background-color":"#e9e9e9","progress-color":"#36d8a9","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Customer Satisfaction","percent":"100","size":"small","icon":"","text-color":"#3a3a3a","background-color":"#e9e9e9","progress-color":"#36d8a9","margin-bottom":"20px"}}],"option":{},"size":"1/2"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"About Us","type":"about-us","option":{"page-item-id":"","style":"plain","caption":"","title":"About Us","content":"<p>Donec ullamcorper nulla non metus auctor fringilla. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec id elit non mi porta gravida at eget metus. Donec id elit non mi porta gravida at eget metus.</p>","read-more-text":"Read More","read-more-link":"#","margin-bottom":"20px"}}],"option":{},"size":"1/2"}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"75px","padding-bottom":"50px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Blog","type":"blog","option":{"page-item-id":"","title-type":"left","title-size":"medium","title":"Recent News","caption":"","right-text":"Read All News","right-text-link":"http://demo.goodlayers.com/totalbusiness/creative03/blog-full-with-right-sidebar/","category":"","tag":"","num-excerpt":"25","num-fetch":"8","blog-style":"blog-1-3","blog-layout":"carousel","thumbnail-size":"small-grid-size","orderby":"date","order":"desc","offset":"","pagination":"disable","enable-sticky":"disable","margin-bottom":"0px"}}],"option":{"page-item-id":"","background-type":"color","background":"#2c2c2c","skin":"totalbusiness-skin-blog-dark","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"60px","padding-bottom":"15px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"350","caption":"Employees","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"12000","caption":"Square Feet","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"2400","caption":"Happy Clients","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"350","caption":"Employees","margin-bottom":"20px"}}],"option":{},"size":"1/4"}],"option":{"page-item-id":"","background-type":"color","background":"#373737","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"97px","padding-bottom":"77px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-1","items":[],"option":{},"size":"1/5"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-1","items":[{"item-type":"item","item-builder-title":"Testimonial","type":"testimonial","option":{"page-item-id":"","testimonial":"[{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|John Smith|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Furniture Fact.|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Etiam porta sem malesuada magna mollis euismod. Maecenas faucibus mollis interdum. Donec ullamcorper nulla non metus auctor fringilla. Nullam id dolor id nibh ultricies vehicula ut id elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Jennefer Lopez|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Singer|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Etiam porta sem malesuada magna mollis euismod. Maecenas faucibus mollis interdum. Donec ullamcorper nulla non metus auctor fringilla. Nullam id dolor id nibh ultricies vehicula ut id elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit.|gq2|}]","title-type":"center","title-size":"large","title":"Testimonial","caption":"","testimonial-columns":"1","testimonial-type":"carousel","testimonial-style":"large plain-style","margin-bottom":"20px"}}],"option":{},"size":"3/5"}],"option":{"page-item-id":"","background-type":"","background":"#ffffff","skin":"","show-section":"","border":"","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"60px","padding-bottom":"40px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Banner","type":"banner","option":{"page-item-id":"","slider":"[[5404,5405,5406,5407,5400],{|gq2|5390|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/wood-about-bg-150x150.jpg|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:150},|gq2|5396|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-1.png|gq2|,|gq2|width|gq2|:147,|gq2|height|gq2|:40},|gq2|5397|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-2-150x26.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:26},|gq2|5398|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-3-150x40.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:40},|gq2|5399|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-4.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:46},|gq2|5400|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-5.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:59},|gq2|5404|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-1.png|gq2|,|gq2|width|gq2|:147,|gq2|height|gq2|:58},|gq2|5405|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-2-150x59.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:59},|gq2|5406|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-3-150x58.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:58},|gq2|5407|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-4.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:59}}]","thumbnail-size":"full","banner-columns":"5","margin-bottom":"20px"}}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"top","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"50px","padding-bottom":"15px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'homepage-7' => array(
					'above-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Full Size Wrapper","type":"full-size-wrapper","items":[{"item-type":"item","item-builder-title":"Master Slider","type":"master-slider","option":{"page-item-id":"","id":"1","margin-bottom":"0px"}}],"option":{"page-item-id":"","skin":"no-skin","background":"#ffffff","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"0px","padding-bottom":"0px"}}]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","title-size":"medium","title":"","caption":"","right-text":"Read All News","right-text-link":"","content":"<p><img class=|gq2|size-medium wp-image-5689 alignright|gq2| style=|gq2|margin-right: 30px;|gq2| src=|gq2|http://demo.goodlayers.com/totalbusiness/coffeeshop/wp-content/uploads/2015/09/service-item.png|gq2| alt=|gq2|service-item|gq2| /></p>","margin-bottom":"20px"}}],"option":{},"size":"1/2"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","title-size":"medium","title":"","caption":"","right-text":"Read All News","right-text-link":"","content":"","margin-bottom":"65px"}},{"item-type":"item","item-builder-title":"List With Icon","type":"icon-with-list","option":{"page-item-id":"","icon-with-list":"[{|gq2|gdl-tab-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/coffeeshop/wp-content/uploads/2015/09/service-icon-1.png|gq2|,|gq2|gdl-tab-image|gq2|:|gq2|5683|gq2|,|gq2|gdl-tab-icon|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Sem Nullam Mollis|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Donec sed odio dui. Maecenas sed diam eget risus varius blandit sit amet non magna. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Cum sociis natoque penatibus et magnis dis parturient montes|gq2|},{|gq2|gdl-tab-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/coffeeshop/wp-content/uploads/2015/09/service-icon-2.png|gq2|,|gq2|gdl-tab-image|gq2|:|gq2|5684|gq2|,|gq2|gdl-tab-icon|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Magna Dolor Ridiculus Adipiscing|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Donec sed odio dui. Maecenas sed diam eget risus varius blandit sit amet non magna. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Cum sociis natoque penatibus et magnis dis parturient montes|gq2|},{|gq2|gdl-tab-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/coffeeshop/wp-content/uploads/2015/09/service-icon-3.png|gq2|,|gq2|gdl-tab-image|gq2|:|gq2|5685|gq2|,|gq2|gdl-tab-icon|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Aenean Magna Sollicitudin Dolor|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Donec sed odio dui. Maecenas sed diam eget risus varius blandit sit amet non magna. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Cum sociis natoque penatibus et magnis dis parturient montes|gq2|}]","title-type":"none","title-size":"medium","title":"","caption":"","align":"left","margin-bottom":"20px"}}],"option":{},"size":"1/2"}],"option":{"page-item-id":"","type":"image","background":"5687","background-mobile":"","background-speed":"0","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"20px","padding-bottom":"20px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Title","type":"title","option":{"page-item-id":"","title-type":"center","title-size":"large","title":"Coffee Price","caption":"","right-text":"Read All News","right-text-link":"","margin-bottom":"85px"}},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[{"item-type":"item","item-builder-title":"Price Item","type":"price-item","option":{"page-item-id":"","image":"5735","title":"Espresso","price":"$1.99 / $2.45 / $2.90","margin-bottom":"55px"}}],"option":{},"size":"1/5"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[{"item-type":"item","item-builder-title":"Price Item","type":"price-item","option":{"page-item-id":"","image":"5736","title":"Lungo","price":"$1.99 / $2.45 / $2.90","margin-bottom":"55px"}}],"option":{},"size":"1/5"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[{"item-type":"item","item-builder-title":"Price Item","type":"price-item","option":{"page-item-id":"","image":"5737","title":"Caffe Afogato","price":"$1.99 / $2.45 / $2.90","margin-bottom":"55px"}}],"option":{},"size":"1/5"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[{"item-type":"item","item-builder-title":"Price Item","type":"price-item","option":{"page-item-id":"","image":"5738","title":"Macchiato","price":"$1.99 / $2.45 / $2.90","margin-bottom":"55px"}}],"option":{},"size":"1/5"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[{"item-type":"item","item-builder-title":"Price Item","type":"price-item","option":{"page-item-id":"","image":"5739","title":"Schiumatto","price":"$1.99 / $2.45 / $2.90","margin-bottom":"55px"}}],"option":{},"size":"1/5"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[{"item-type":"item","item-builder-title":"Price Item","type":"price-item","option":{"page-item-id":"","image":"5740","title":"Black Eye","price":"$1.99 / $2.45 / $2.90","margin-bottom":"55px"}}],"option":{},"size":"1/5"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[{"item-type":"item","item-builder-title":"Price Item","type":"price-item","option":{"page-item-id":"","image":"5741","title":"Doppio","price":"$1.99 / $2.45 / $2.90","margin-bottom":"55px"}}],"option":{},"size":"1/5"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[{"item-type":"item","item-builder-title":"Price Item","type":"price-item","option":{"page-item-id":"","image":"5742","title":"Cappucino","price":"$1.99 / $2.45 / $2.90","margin-bottom":"55px"}}],"option":{},"size":"1/5"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[{"item-type":"item","item-builder-title":"Price Item","type":"price-item","option":{"page-item-id":"","image":"5743","title":"Viennois","price":"$1.99 / $2.45 / $2.90","margin-bottom":"55px"}}],"option":{},"size":"1/5"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[{"item-type":"item","item-builder-title":"Price Item","type":"price-item","option":{"page-item-id":"","image":"5744","title":"Con Panna","price":"$1.99 / $2.45 / $2.90","margin-bottom":"55px"}}],"option":{},"size":"1/5"}],"option":{"page-item-id":"","type":"image","background":"5747","background-mobile":"","background-speed":"0.1","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"totalbusiness-skin-dark-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"100px","padding-bottom":"65px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Portfolio","type":"portfolio","option":{"page-item-id":"","title-type":"none","title-size":"medium","title":"Featured Works","caption":"","right-text":"View All Works","right-text-link":"#","category":"","tag":"","portfolio-style":"modern-portfolio","num-fetch":"6","num-excerpt":"20","portfolio-size":"1/3","portfolio-layout":"fitRows","portfolio-filter":"disable","thumbnail-size":"portfolio-half","thumbnail-size-featured":"thumbnail","orderby":"date","order":"desc","pagination":"disable","margin-bottom":"0px"}}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"80px","padding-bottom":"0px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Stunning Text","type":"stunning-text","option":{"page-item-id":"","style":"left","title":"It\'s The Best WordPress Theme.","caption":"This theme comes with many awesome features and it suits to any kind of businesses. You will love it!","button-text":"Learn More","button-link":"#","button2-text":"Buy Now!","button2-link":"","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"5379","background-mobile":"","background-speed":"0.05","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"85px","padding-bottom":"65px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[],"option":{},"size":"1/5"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"center","title-size":"large","title":"Our Vision","caption":"","right-text":"Read All News","right-text-link":"","content":"<p style=|gq2|text-align: center;|gq2|>Cras justo odio, dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec id elit non mi porta gravida at eget metus. Donec id elit non mi porta gravida at eget metus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Curabitur blandit tempus porttitor. Donec ullamcorper nulla non metus auctor fringilla. Nulla vitae elit libero, a pharetra augue. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Praesent commodo cursus magna.</p><p style=|gq2|text-align: center;|gq2|>Cras mattis consectetur purus sit amet fermentum. Curabitur blandit tempus porttitor. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Aenean lacinia bibendum nulla sed consectetur. Etiam porta sem malesuada magna mollis euismod. Donec ullamcorper nulla non metus auctor fringilla. Maecenas faucibus mollis interdum.</p><p style=|gq2|text-align: center;|gq2|><a href=|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/wood-vision-sig.png|gq2|><img class=|gq2|alignnone size-full wp-image-5420|gq2| src=|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/wood-vision-sig.png|gq2| alt=|gq2|wood-vision-sig|gq2| width=|gq2|197|gq2| height=|gq2|34|gq2| /></a></p><p style=|gq2|text-align: center;|gq2|><strong>Paul Heizenberg</strong><br /> CEO of Total Factory</p>","margin-bottom":"20px"}}],"option":{},"size":"3/5"}],"option":{"page-item-id":"","type":"image","background":"5700","background-mobile":"","background-speed":"0","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"totalbusiness-skin-dark-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"105px","padding-bottom":"70px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"350","caption":"Employees","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"12000","caption":"Square Feet","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"2400","caption":"Happy Clients","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"350","caption":"Employees","margin-bottom":"20px"}}],"option":{},"size":"1/4"}],"option":{"page-item-id":"","background-type":"color","background":"#242424","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"98px","padding-bottom":"73px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[],"option":{},"size":"1/5"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[{"item-type":"item","item-builder-title":"Testimonial","type":"testimonial","option":{"page-item-id":"","testimonial":"[{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|John Smoth|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Furniture Fact|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Etiam porta sem malesuada magna mollis euismod. Maecenas faucibus mollis interdum. Donec ullamcorper nulla non metus auctor fringilla. Nullam id dolor id nibh ultricies vehicula ut id elit. Lorem ipsum dolor sit amet, consectetur.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Paul Johnson|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Apple|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Nulla vitae elit libero, a pharetra augue. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Donec id elit non mi porta gravida at eget metus. Maecenas faucibus mollis interdum.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Alan Smith|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Wooden Corp.|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Nullam quis risus eget urna mollis ornare vel eu leo. Aenean lacinia bibendum nulla sed consectetur.|gq2|}]","title-type":"center","title-size":"medium","title":"Testimonial","caption":"","testimonial-columns":"1","testimonial-type":"carousel","testimonial-style":"large plain-style","margin-bottom":"20px"}}],"option":{},"size":"2/3"}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"75px","padding-bottom":"55px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'homepage-8' => array(
					'above-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Full Size Wrapper","type":"full-size-wrapper","items":[{"item-type":"item","item-builder-title":"Master Slider","type":"master-slider","option":{"page-item-id":"","id":"1","margin-bottom":"0px"}}],"option":{"page-item-id":"","skin":"no-skin","background":"#ffffff","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"0px","padding-bottom":"0px"}}]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Full Size Wrapper","type":"full-size-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Image / Frame","type":"image-frame","option":{"page-item-id":"","image-id":"5710","thumbnail-size":"portfolio-portrait","link-type":"content","title":"Condimentum Adipi scing Malesuada","content":"Sed posuere consectetur est at lob ortis. Etiam porta sem malesuada mag na mollis euismod. Nulla vitae.","url":"","frame-type":"none","frame-background":"#dddddd","margin-bottom":"0px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Image / Frame","type":"image-frame","option":{"page-item-id":"","image-id":"5756","thumbnail-size":"portfolio-portrait","link-type":"content","title":"Nibh Consectetur Vehicula","content":"Sed posuere consectetur est at lob ortis. Etiam porta sem malesuada mag na mollis euismod. Nulla vitae.","url":"","frame-type":"none","frame-background":"#dddddd","margin-bottom":"0px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Image / Frame","type":"image-frame","option":{"page-item-id":"","image-id":"5757","thumbnail-size":"portfolio-portrait","link-type":"content","title":"Parturient Justo Dapibus","content":"Sed posuere consectetur est at lob ortis. Etiam porta sem malesuada mag na mollis euismod. Nulla vitae.","url":"","frame-type":"none","frame-background":"#dddddd","margin-bottom":"0px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Image / Frame","type":"image-frame","option":{"page-item-id":"","image-id":"5758","thumbnail-size":"portfolio-portrait","link-type":"content","title":"Dolor Sit Vulputate","content":"Sed posuere consectetur est at lob ortis. Etiam porta sem malesuada mag na mollis euismod. Nulla vitae.","url":"","frame-type":"none","frame-background":"#dddddd","margin-bottom":"0px"}}],"option":{},"size":"1/4"}],"option":{"page-item-id":"","skin":"no-skin","background":"#ffffff","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"0px","padding-bottom":"0px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5688","icon":"","title":"Commodo Fringill","style":"type-2-hover","hover-bg":"#db3b3b","hover-text":"#ffffff","content":"<p>Donec ullamcorper nulla non metus auctor fringilla. Integer posuere erat a ante venenatis dapibus posuere velit, aliquet. Nulla vitae elit libero.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"0px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5761","icon":"","title":"Mattis Sollicitudin","style":"type-2-hover","hover-bg":"#db3b3b","hover-text":"#ffffff","content":"<p>Donec ullamcorper nulla non metus auctor fringilla. Integer posuere erat a ante venenatis dapibus posuere velit, aliquet. Nulla vitae elit libero.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"0px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5762","icon":"","title":"Ultricies Purus","style":"type-2-hover","hover-bg":"#db3b3b","hover-text":"#ffffff","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"0px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5691","icon":"","title":"Ornare Tristique","style":"type-2-hover","hover-bg":"#db3b3b","hover-text":"#ffffff","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"0px"}}],"option":{},"size":"1/4"}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"0px","padding-bottom":"0px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[],"option":{},"size":"1/2"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"About Us","type":"about-us","option":{"page-item-id":"","style":"plain-large","caption":"Little Story","title":"About Us","content":"<p>Sed posuere consectetur est at lobortis. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Etiam porta sem malesuada magna mollis euismod. Nullam quis risus eget urna mollis ornare vel eu leo. Maecenas sed diam eget risus varius blandit sit amet non magna. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Cras mattis consectetur purus sit amet fermentum. Cum sociis natoque penatibus.</p>","read-more-text":"Read More","read-more-link":"#","margin-bottom":"20px"}}],"option":{},"size":"1/2"}],"option":{"page-item-id":"","type":"image","background":"5699","background-mobile":"","background-speed":"0","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"totalbusiness-skin-dark-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"95px","padding-bottom":"65px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Stunning Text","type":"stunning-text","option":{"page-item-id":"","style":"center","title":"It\'s The Best WordPress Theme.","caption":"This theme comes with many awesome features and it suits to any kind of businesses. You will love it!","button-text":"Learn More","button-link":"#","button2-text":"Buy Now!","button2-link":"","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"5704","background-mobile":"","background-speed":"0.05","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"totalbusiness-skin-dark-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"65px","padding-bottom":"35px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","title-size":"medium","title":"","caption":"","right-text":"Read All News","right-text-link":"","content":"","margin-bottom":"65px"}},{"item-type":"item","item-builder-title":"Image / Frame","type":"image-frame","option":{"page-item-id":"","image-id":"5747","thumbnail-size":"full","link-type":"none","title":"","content":"","url":"","frame-type":"none","frame-background":"#dddddd","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","title-size":"medium","title":"","caption":"","right-text":"Read All News","right-text-link":"","content":"","margin-bottom":"65px"}},{"item-type":"item","item-builder-title":"Image / Frame","type":"image-frame","option":{"page-item-id":"","image-id":"5748","thumbnail-size":"full","link-type":"none","title":"","content":"","url":"","frame-type":"none","frame-background":"#dddddd","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Menu List","type":"menu","option":{"page-item-id":"","content":"[{|gq2|gdl-tab-title|gq2|:|gq2|Strawberry Cheese Pie|gq2|,|gq2|caption|gq2|:|gq2|Nullam Quam Malesuada Lorem|gq2|,|gq2|price|gq2|:|gq2|$14|gq2|,|gq2|icon|gq2|:|gq2|fa-thumbs-up|gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Cookies and Cream|gq2|,|gq2|caption|gq2|:|gq2|Nullam Quam Malesuada Lorem|gq2|,|gq2|price|gq2|:|gq2|$12|gq2|,|gq2|icon|gq2|:|gq2||gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Rainbow Macaroon|gq2|,|gq2|caption|gq2|:|gq2|Nullam Quam Malesuada Lorem|gq2|,|gq2|price|gq2|:|gq2|$34|gq2|,|gq2|icon|gq2|:|gq2||gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Tiramissu|gq2|,|gq2|caption|gq2|:|gq2|Nullam Quam Malesuada Lorem|gq2|,|gq2|price|gq2|:|gq2|$14|gq2|,|gq2|icon|gq2|:|gq2||gq2|}]","title-type":"left","title-size":"large","title":"Popular Menu","caption":"","margin-bottom":"20px"}}],"option":{},"size":"1/2"}],"option":{"page-item-id":"","background-type":"","background":"#ffffff","skin":"","show-section":"","border":"","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"60px","padding-bottom":"40px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[],"option":{},"size":"1/5"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[{"item-type":"item","item-builder-title":"Testimonial","type":"testimonial","option":{"page-item-id":"","testimonial":"[{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|John Smoth|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Furniture Fact|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Etiam porta sem malesuada magna mollis euismod. Maecenas faucibus mollis interdum. Donec ullamcorper nulla non metus auctor fringilla. Nullam id dolor id nibh ultricies vehicula ut id elit. Lorem ipsum dolor sit amet, consectetur.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Paul Johnson|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Apple|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Nulla vitae elit libero, a pharetra augue. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Donec id elit non mi porta gravida at eget metus. Maecenas faucibus mollis interdum.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Alan Smith|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Wooden Corp.|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Nullam quis risus eget urna mollis ornare vel eu leo. Aenean lacinia bibendum nulla sed consectetur.|gq2|}]","title-type":"center","title-size":"large","title":"Testimonial","caption":"","testimonial-columns":"1","testimonial-type":"carousel","testimonial-style":"large plain-style","margin-bottom":"20px"}}],"option":{},"size":"2/3"}],"option":{"page-item-id":"","type":"image","background":"5707","background-mobile":"","background-speed":"0","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"totalbusiness-skin-dark-testimonial","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"100px","padding-bottom":"45px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'homepage-9' => array(
					'above-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Full Size Wrapper","type":"full-size-wrapper","items":[{"item-type":"item","item-builder-title":"Master Slider","type":"master-slider","option":{"page-item-id":"","id":"1","margin-bottom":"0px"}}],"option":{"page-item-id":"","skin":"no-skin","background":"#ffffff","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"0px","padding-bottom":"0px"}}]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"About Us","type":"about-us","option":{"page-item-id":"","style":"title-left","caption":"","title":"Little Story <br/>Abouts Us","content":"<p><strong>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</strong></p><p>Curabitur blandit tempus porttitor. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Sed posuere consectetur est at lobortis. Donec sed odio dui. Donec sed odio dui. Maecenas faucibus mollis interdum. Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Aenean lacinia bibendum nulla sed consectetur. Maecenas sed diam eget risus varius blandit sit amet non magna.</p>","read-more-text":"Read More","read-more-link":"#","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"5680","background-mobile":"","background-speed":"0","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"45px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5682","icon":"","title":"Commodo Fringilla Nibh","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"40px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5697","icon":"","title":"Mattis Sollicitudin","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"40px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5684","icon":"","title":"Ultricies Purus Tristique","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"40px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5695","icon":"","title":"Tristique Egestas Dolor","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"40px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5686","icon":"","title":"Amet Tristique Magna","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"40px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5687","icon":"","title":"Ornare Cras Ultricies","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"40px"}}],"option":{},"size":"1/3"}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"30px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Portfolio","type":"portfolio","option":{"page-item-id":"","title-type":"none","title-size":"medium","title":"Featured Works","caption":"","right-text":"View All Works","right-text-link":"#","category":"all","tag":"","portfolio-style":"modern-portfolio","num-fetch":"11","num-excerpt":"20","portfolio-size":"1/3","portfolio-layout":"masonry-style-2","portfolio-filter":"enable","thumbnail-size":"portfolio-half","thumbnail-size-featured":"portfolio-featured","orderby":"date","order":"desc","pagination":"disable","margin-bottom":"0px"}}],"option":{"page-item-id":"","type":"image","background":"5680","background-mobile":"","background-speed":"0","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"80px","padding-bottom":"70px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#444444","caption-color":"#444444","title":"2100","caption":"Weddings","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#e0447f","caption-color":"#444444","title":"120","caption":"Great Staffs","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#444444","caption-color":"#444444","title":"5300","caption":"Happy Clients","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#e0447f","caption-color":"#444444","title":"120000","caption":"Photos Taken","margin-bottom":"20px"}}],"option":{},"size":"1/4"}],"option":{"page-item-id":"","type":"image","background":"5703","background-mobile":"","background-speed":"0.1","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"135px","padding-bottom":"90px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Title","type":"title","option":{"page-item-id":"","title-type":"left","title-size":"small","title":"Video Tour","caption":"","right-text":"Read All News","right-text-link":"","margin-bottom":"45px"}},{"item-type":"item","item-builder-title":"Video","type":"video","option":{"page-item-id":"","url":"https://vimeo.com/97340119","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[{"item-type":"item","item-builder-title":"Testimonial","type":"testimonial","option":{"page-item-id":"","testimonial":"[{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|John Smoth|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Furniture Fact|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Etiam porta sem malesuada magna mollis euismod. Maecenas faucibus mollis interdum. Donec ullamcorper nulla non metus auctor fringilla. Nullam id dolor id nibh ultricies vehicula ut id elit. Lorem ipsum dolor sit.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Paul Johnson|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Apple|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Nulla vitae elit libero, a pharetra augue. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Donec id elit non mi porta gravida at eget metus. Maecenas faucibus mollis interdum.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Alan Smith|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Wooden Corp.|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Nulla vitae elit libero, a pharetra augue. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Donec id elit non mi porta gravida at eget metus. Maecenas faucibus mollis interdum.|gq2|}]","title-type":"left","title-size":"small","title":"Testimonial","caption":"","testimonial-columns":"1","testimonial-type":"carousel","testimonial-style":"totalbusiness-left plain-style","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[{"item-type":"item","item-builder-title":"Blog","type":"blog","option":{"page-item-id":"","title-type":"left","title-size":"small","title":"Recent News","caption":"","right-text":"Read All News","right-text-link":"http://demo.goodlayers.com/totalbusiness/weddingplanner/?page_id=29","category":"","tag":"","num-excerpt":"25","num-fetch":"3","blog-style":"blog-widget-1-1","blog-layout":"carousel","thumbnail-size":"round-personnel-size","orderby":"date","order":"desc","offset":"","pagination":"disable","enable-sticky":"disable","margin-bottom":"0px"}}],"option":{},"size":"1/3"}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"20px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'about-1' => array(
					'above-sidebar'=>'[]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"About Us","type":"about-us","option":{"page-item-id":"","style":"plain","caption":"","title":"About Us","content":"<p>Donec ullamcorper nulla non metus auctor fringilla. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec id elit non mi porta gravida at eget metus. Donec id elit non mi porta gravida at eget metus.</p>","read-more-text":"Read More","read-more-link":"#","margin-bottom":"20px"}}],"option":{},"size":"1/2"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Advanced Technologies","percent":"80","size":"small","icon":"","text-color":"#ffffff","background-color":"#e9e9e9","progress-color":"#36bddb","margin-bottom":"25px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Production Capacity","percent":"95","size":"small","icon":"","text-color":"#ffffff","background-color":"#e9e9e9","progress-color":"#36bddb","margin-bottom":"25px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Utilization Rate","percent":"70","size":"small","icon":"","text-color":"#ffffff","background-color":"#e9e9e9","progress-color":"#36bddb","margin-bottom":"25px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Customer Satisfaction","percent":"100","size":"small","icon":"","text-color":"#ffffff","background-color":"#e9e9e9","progress-color":"#36bddb","margin-bottom":"25px"}}],"option":{},"size":"1/2"}],"option":{"page-item-id":"","background-type":"color","background":"#2a2a2a","skin":"totalbusiness-skin-dark-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"75px","padding-bottom":"50px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5370","icon":"","title":"Commodo Fringilla Nibh","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5371","icon":"","title":"Mattis Sollicitudin","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5373","icon":"","title":"Ultricies Purus Tristique","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5372","icon":"","title":"Tristique Egestas Dolor","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5374","icon":"","title":"Amet Tristique Magna","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5375","icon":"","title":"Ornare Cras Ultricies","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"30px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"350","caption":"Employees","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"12000","caption":"Square Feet","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"2400","caption":"Happy Clients","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"350","caption":"Employees","margin-bottom":"20px"}}],"option":{},"size":"1/4"}],"option":{"page-item-id":"","type":"image","background":"5387","background-mobile":"","background-speed":"0.1","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"100px","padding-bottom":"70px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"left","title-size":"large","title":"Our Vision","caption":"","right-text":"Read All News","right-text-link":"","content":"<p>Cras justo odio, dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec id elit non mi porta gravida at eget metus. Donec id elit non mi porta gravida at eget metus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Curabitur blandit tempus porttitor. Donec ullamcorper nulla non metus auctor fringilla. Nulla vitae elit libero, a pharetra augue. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Nullam id dolor id nibh ultricies vehicula ut id elit.</p><p><a href=|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/wood-vision-sig.png|gq2|><img class=|gq2|alignnone size-full wp-image-5420|gq2| src=|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/wood-vision-sig.png|gq2| alt=|gq2|wood-vision-sig|gq2| width=|gq2|197|gq2| height=|gq2|34|gq2| /></a></p><p><strong>Paul Heizenberg</strong><br /> CEO of Total Factory</p>","margin-bottom":"20px"}}],"option":{},"size":"1/2"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[],"option":{},"size":"1/2"}],"option":{"page-item-id":"","type":"image","background":"5390","background-mobile":"","background-speed":"0","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"totalbusiness-skin-dark-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"80px","padding-bottom":"65px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[],"option":{},"size":"1/5"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[{"item-type":"item","item-builder-title":"Testimonial","type":"testimonial","option":{"page-item-id":"","testimonial":"[{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|John Smoth|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Furniture Fact|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Etiam porta sem malesuada magna mollis euismod. Maecenas faucibus mollis interdum. Donec ullamcorper nulla non metus auctor fringilla. Nullam id dolor id nibh ultricies vehicula ut id elit. Lorem ipsum dolor sit amet, consectetur.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Paul Johnson|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Apple|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Nulla vitae elit libero, a pharetra augue. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Donec id elit non mi porta gravida at eget metus. Maecenas faucibus mollis interdum.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Alan Smith|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Wooden Corp.|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Nullam quis risus eget urna mollis ornare vel eu leo. Aenean lacinia bibendum nulla sed consectetur. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit.|gq2|}]","title-type":"center","title-size":"medium","title":"Testimonial","caption":"","testimonial-columns":"1","testimonial-type":"carousel","testimonial-style":"large plain-style","margin-bottom":"20px"}}],"option":{},"size":"2/3"}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"20px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Banner","type":"banner","option":{"page-item-id":"","slider":"[[5404,5405,5406,5407,5400],{|gq2|5390|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/wood-about-bg-150x150.jpg|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:150},|gq2|5396|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-1.png|gq2|,|gq2|width|gq2|:147,|gq2|height|gq2|:40},|gq2|5397|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-2-150x26.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:26},|gq2|5398|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-3-150x40.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:40},|gq2|5399|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-4.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:46},|gq2|5400|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-5.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:59},|gq2|5404|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-1.png|gq2|,|gq2|width|gq2|:147,|gq2|height|gq2|:58},|gq2|5405|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-2-150x59.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:59},|gq2|5406|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-3-150x58.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:58},|gq2|5407|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-4.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:59}}]","thumbnail-size":"full","banner-columns":"5","margin-bottom":"20px"}}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"top","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"50px","padding-bottom":"15px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'about-2' => array(
					'above-sidebar'=>'[]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Title","type":"title","option":{"page-item-id":"","title-type":"center","title-size":"extra-large","title":"About Total Business","caption":"Donec ullamcorper nulla non metus auctor","right-text":"Read All News","right-text-link":"","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"5464","background-mobile":"","background-speed":"0","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"totalbusiness-skin-dark-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"225px","padding-bottom":"205px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"About Us","type":"about-us","option":{"page-item-id":"","style":"plain","caption":"","title":"Our Story","content":"<p>Donec ullamcorper nulla non metus auctor fringilla. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec id elit non mi porta gravida at eget metus. Donec id elit non mi porta gravida at eget metus. Cras mattis consectetur purus sit amet fermentum. Aenean eu leo quam.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"20px"}}],"option":{},"size":"1/2"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"About Us","type":"about-us","option":{"page-item-id":"","style":"plain","caption":"","title":"Our Vision","content":"<p>Donec ullamcorper nulla non metus auctor fringilla. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec id elit non mi porta gravida at eget metus. Donec id elit non mi porta gravida at eget metus. Cras mattis consectetur purus sit amet fermentum. Aenean eu leo quam.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"20px"}}],"option":{},"size":"1/2"}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"75px","padding-bottom":"50px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Stunning Text","type":"stunning-text","option":{"page-item-id":"","style":"center","title":"It\'s The Best WordPress Theme.","caption":"This theme comes with many awesome features and it suits to any kind of businesses. You will love it!","button-text":"Learn More","button-link":"#","button2-text":"Buy Now!","button2-link":"#","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"5469","background-mobile":"","background-speed":"0","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"totalbusiness-skin-dark-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"135px","padding-bottom":"105px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5370","icon":"","title":"Commodo Fringilla Nibh","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5371","icon":"","title":"Mattis Sollicitudin","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5373","icon":"","title":"Ultricies Purus Tristique","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5372","icon":"","title":"Tristique Egestas Dolor","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5374","icon":"","title":"Amet Tristique Magna","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5375","icon":"","title":"Ornare Cras Ultricies","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"30px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"350","caption":"Employees","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"12000","caption":"Square Feet","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"2400","caption":"Happy Clients","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"350","caption":"Employees","margin-bottom":"20px"}}],"option":{},"size":"1/4"}],"option":{"page-item-id":"","type":"image","background":"5387","background-mobile":"","background-speed":"0.1","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"100px","padding-bottom":"70px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'about-3' => array(
					'above-sidebar'=>'[]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Title","type":"title","option":{"page-item-id":"","title-type":"center","title-size":"extra-large","title":"About Total Business","caption":"Donec ullamcorper nulla non metus auctor","right-text":"Read All News","right-text-link":"","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"5475","background-mobile":"","background-speed":"0","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"200px","padding-bottom":"170px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Advanced Technologies","percent":"80","size":"small","icon":"","text-color":"#606060","background-color":"#e9e9e9","progress-color":"#36bddb","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Production Capacity","percent":"95","size":"small","icon":"","text-color":"#606060","background-color":"#e9e9e9","progress-color":"#36bddb","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Utilization Rate","percent":"70","size":"small","icon":"","text-color":"#606060","background-color":"#e9e9e9","progress-color":"#36bddb","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Customer Satisfaction","percent":"100","size":"small","icon":"","text-color":"#606060","background-color":"#e9e9e9","progress-color":"#36bddb","margin-bottom":"25px"}}],"option":{},"size":"1/2"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"About Us","type":"about-us","option":{"page-item-id":"","style":"plain","caption":"","title":"About Us","content":"<p>Donec ullamcorper nulla non metus auctor fringilla. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec id elit non mi porta gravida at eget metus. Donec id elit non mi porta gravida at eget metus. Nulla vitae elit libero.</p>","read-more-text":"Read More","read-more-link":"#","margin-bottom":"20px"}}],"option":{},"size":"1/2"}],"option":{"page-item-id":"","background-type":"color","background":"#f9f9f9","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"75px","padding-bottom":"50px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5370","icon":"","title":"Commodo Fringilla Nibh","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5371","icon":"","title":"Mattis Sollicitudin","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5373","icon":"","title":"Ultricies Purus Tristique","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5372","icon":"","title":"Tristique Egestas Dolor","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5374","icon":"","title":"Amet Tristique Magna","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5375","icon":"","title":"Ornare Cras Ultricies","style":"type-2","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"30px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[],"option":{},"size":"1/5"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[{"item-type":"item","item-builder-title":"Testimonial","type":"testimonial","option":{"page-item-id":"","testimonial":"[{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|John Smoth|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Furniture Fact|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Etiam porta sem malesuada magna mollis euismod. Maecenas faucibus mollis interdum. Donec ullamcorper nulla non metus auctor fringilla. Nullam id dolor id nibh ultricies vehicula ut id elit. Lorem ipsum dolor sit amet, consectetur.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Paul Johnson|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Apple|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Nulla vitae elit libero, a pharetra augue. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Donec id elit non mi porta gravida at eget metus. Maecenas faucibus mollis interdum.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Alan Smith|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Wooden Corp.|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Nullam quis risus eget urna mollis ornare vel eu leo. Aenean lacinia bibendum nulla sed consectetur. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit.|gq2|}]","title-type":"center","title-size":"medium","title":"Testimonial","caption":"","testimonial-columns":"1","testimonial-type":"carousel","testimonial-style":"large plain-style","margin-bottom":"20px"}}],"option":{},"size":"2/3"}],"option":{"page-item-id":"","type":"image","background":"5476","background-mobile":"","background-speed":"0","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"totalbusiness-skin-dark-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"90px","padding-bottom":"50px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Personnel","type":"personnel","option":{"page-item-id":"","personnel":"[{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/07/personnel-1.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|5440|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|John Smith|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Chief Executive Officer|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Fusce dapibus, tellus ac cursus comm odo, tortor mauris condim entum nibh, ut ferme ntum massa justo sit amet risus. Donec  Fusce dapibus, tellus ac.|gq2|,|gq2|gdl-tab-social-list|gq2|:|gq2|[gdlr_icon type=|gq6|fa-facebook|gq6| size=|gq6|17px|gq6| color=|gq6|#777777|gq6|] [gdlr_icon type=|gq6|fa-twitter|gq6| size=|gq6|17px|gq6| color=|gq6|#777777|gq6|] [gdlr_icon type=|gq6|fa-linkedin|gq6| size=|gq6|17px|gq6| color=|gq6|#777777|gq6|] [gdlr_icon type=|gq6|fa-skype|gq6| size=|gq6|17px|gq6| color=|gq6|#777777|gq6|] |g2n|[gdlr_space height=|gq6|35px|gq6|]|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/07/personnel-2.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|5441|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|John Doe|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Chief Financial Officer|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Fusce dapibus, tellus ac cursus comm odo, tortor mauris condim entum nibh, ut ferme ntum massa justo sit amet risus. Donec  Fusce dapibus, tellus ac.|gq2|,|gq2|gdl-tab-social-list|gq2|:|gq2|[gdlr_icon type=|gq6|fa-facebook|gq6| size=|gq6|17px|gq6| color=|gq6|#777777|gq6|] [gdlr_icon type=|gq6|fa-twitter|gq6| size=|gq6|17px|gq6| color=|gq6|#777777|gq6|] [gdlr_icon type=|gq6|fa-linkedin|gq6| size=|gq6|17px|gq6| color=|gq6|#777777|gq6|] [gdlr_icon type=|gq6|fa-skype|gq6| size=|gq6|17px|gq6| color=|gq6|#777777|gq6|] |g2n|[gdlr_space height=|gq6|35px|gq6|]|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/07/personnel-5.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|5444|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Paul Smith|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|General Manager|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Fusce dapibus, tellus ac cursus comm odo, tortor mauris condim entum nibh, ut ferme ntum massa justo sit amet risus. Donec  Fusce dapibus, tellus ac.|gq2|,|gq2|gdl-tab-social-list|gq2|:|gq2|[gdlr_icon type=|gq6|fa-facebook|gq6| size=|gq6|17px|gq6| color=|gq6|#777777|gq6|] [gdlr_icon type=|gq6|fa-twitter|gq6| size=|gq6|17px|gq6| color=|gq6|#777777|gq6|] [gdlr_icon type=|gq6|fa-linkedin|gq6| size=|gq6|17px|gq6| color=|gq6|#777777|gq6|] [gdlr_icon type=|gq6|fa-skype|gq6| size=|gq6|17px|gq6| color=|gq6|#777777|gq6|] |g2n|[gdlr_space height=|gq6|35px|gq6|]|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/07/personnel-6.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|5445|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Ricardo Johnson|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Customer Relation|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Fusce dapibus, tellus ac cursus comm odo, tortor mauris condim entum nibh, ut ferme ntum massa justo sit amet risus. Donec  Fusce dapibus, tellus ac.|gq2|,|gq2|gdl-tab-social-list|gq2|:|gq2|[gdlr_icon type=|gq6|fa-facebook|gq6| size=|gq6|17px|gq6| color=|gq6|#777777|gq6|] [gdlr_icon type=|gq6|fa-twitter|gq6| size=|gq6|17px|gq6| color=|gq6|#777777|gq6|] [gdlr_icon type=|gq6|fa-linkedin|gq6| size=|gq6|17px|gq6| color=|gq6|#777777|gq6|] [gdlr_icon type=|gq6|fa-skype|gq6| size=|gq6|17px|gq6| color=|gq6|#777777|gq6|] |g2n|[gdlr_space height=|gq6|35px|gq6|]|gq2|}]","title-type":"center","title-size":"medium","title":"Meet The Team","caption":"","personnel-columns":"4","personnel-type":"static","personnel-style":"plain-style","thumbnail-size":"small-grid-size","margin-bottom":"20px"}}],"option":{"page-item-id":"","background-type":"color","background":"#f9f9f9","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"75px","padding-bottom":"30px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Banner","type":"banner","option":{"page-item-id":"","slider":"[[5404,5405,5406,5407,5400],{|gq2|5390|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/wood-about-bg-150x150.jpg|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:150},|gq2|5396|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-1.png|gq2|,|gq2|width|gq2|:147,|gq2|height|gq2|:40},|gq2|5397|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-2-150x26.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:26},|gq2|5398|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-3-150x40.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:40},|gq2|5399|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-4.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:46},|gq2|5400|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-5.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:59},|gq2|5404|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-1.png|gq2|,|gq2|width|gq2|:147,|gq2|height|gq2|:58},|gq2|5405|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-2-150x59.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:59},|gq2|5406|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-3-150x58.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:58},|gq2|5407|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-4.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:59}}]","thumbnail-size":"full","banner-columns":"5","margin-bottom":"20px"}}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"top","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"50px","padding-bottom":"15px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'service-1' => array(
					'above-sidebar'=>'[]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Title","type":"title","option":{"page-item-id":"","title-type":"center","title-size":"extra-large","title":"Our Services","caption":"Donec ullamcorper nulla non metus auctor","right-text":"Read All News","right-text-link":"","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"5501","background-mobile":"","background-speed":"0","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"115px","padding-bottom":"85px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5506","icon":"","title":"Interior Design","style":"type-3","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"#","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5505","icon":"","title":"Wood Carfting","style":"type-3","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"#","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5507","icon":"","title":"Wood Flooring","style":"type-3","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"#","margin-bottom":"20px"}}],"option":{},"size":"1/3"}],"option":{"page-item-id":"","background-type":"","background":"#ffffff","skin":"","show-section":"","border":"","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"60px","padding-bottom":"40px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"350","caption":"Employees","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"12000","caption":"Square Feet","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"2400","caption":"Happy Clients","margin-bottom":"20px"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Item","type":"skill-item","option":{"page-item-id":"","title-color":"#ffffff","caption-color":"#ffffff","title":"350","caption":"Employees","margin-bottom":"20px"}}],"option":{},"size":"1/4"}],"option":{"page-item-id":"","type":"image","background":"5387","background-mobile":"","background-speed":"0.1","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"100px","padding-bottom":"70px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"List With Icon","type":"icon-with-list","option":{"page-item-id":"","icon-with-list":"[{|gq2|gdl-tab-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/icon-list-1.png|gq2|,|gq2|gdl-tab-image|gq2|:|gq2|5529|gq2|,|gq2|gdl-tab-icon|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Tellus Ultricies Fermentum Cras Vehicula|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Donec sed odio dui. Maecenas sed diam eget risus varius blandit sit amet non magna. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Cum sociis natoque penatibus et magnis dis parturient montes|gq2|},{|gq2|gdl-tab-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/icon-list-2.png|gq2|,|gq2|gdl-tab-image|gq2|:|gq2|5530|gq2|,|gq2|gdl-tab-icon|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Vulputate Inceptos Dapibus|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Donec sed odio dui. Maecenas sed diam eget risus varius blandit sit amet non magna. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Cum sociis natoque penatibus et magnis dis parturient montes|gq2|},{|gq2|gdl-tab-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/icon-list-3.png|gq2|,|gq2|gdl-tab-image|gq2|:|gq2|5531|gq2|,|gq2|gdl-tab-icon|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Fringilla Tortor Ligula Sit Magna|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Donec sed odio dui. Maecenas sed diam eget risus varius blandit sit amet non magna. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Cum sociis natoque penatibus et magnis dis parturient montes|gq2|}]","title-type":"none","title-size":"medium","title":"","caption":"","align":"right","margin-bottom":"0px"}}],"option":{},"size":"1/2"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"List With Icon","type":"icon-with-list","option":{"page-item-id":"","icon-with-list":"[{|gq2|gdl-tab-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/icon-list-4.png|gq2|,|gq2|gdl-tab-image|gq2|:|gq2|5532|gq2|,|gq2|gdl-tab-icon|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Etiam porta sem malesuada|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Donec sed odio dui. Maecenas sed diam eget risus varius blandit sit amet non magna. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Cum sociis natoque penatibus et magnis dis parturient montes|gq2|},{|gq2|gdl-tab-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/icon-list-5.png|gq2|,|gq2|gdl-tab-image|gq2|:|gq2|5533|gq2|,|gq2|gdl-tab-icon|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Lorem Amet Ornare|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Donec sed odio dui. Maecenas sed diam eget risus varius blandit sit amet non magna. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Cum sociis natoque penatibus et magnis dis parturient montes|gq2|},{|gq2|gdl-tab-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/icon-list-6.png|gq2|,|gq2|gdl-tab-image|gq2|:|gq2|5534|gq2|,|gq2|gdl-tab-icon|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Adipiscing Etiam Dolor Justo|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Donec sed odio dui. Maecenas sed diam eget risus varius blandit sit amet non magna. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Cum sociis natoque penatibus et magnis dis parturient montes|gq2|}]","title-type":"none","title-size":"medium","title":"","caption":"","align":"left","margin-bottom":"0px"}}],"option":{},"size":"1/2"},{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","title-size":"medium","title":"","caption":"","right-text":"Read All News","right-text-link":"","content":"<p style=|gq2|text-align: center;|gq2|>[gdlr_button href=|gq2|http://www.goodlayers.com|gq2| target=|gq2|_self|gq2| size=|gq2|medium|gq2| background=|gq2|#36bddb|gq2| color=|gq2|#ffffff|gq2|]Learn More[/gdlr_button]<br /> [gdlr_button href=|gq2|http://www.goodlayers.com|gq2| target=|gq2|_self|gq2| size=|gq2|medium|gq2| background=|gq2|#36bddb|gq2| color=|gq2|#ffffff|gq2|]Buy Now![/gdlr_button]</p>","margin-bottom":"20px"}}],"option":{"page-item-id":"","background-type":"color","background":"#f7f7f7","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"30px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Banner","type":"banner","option":{"page-item-id":"","slider":"[[5404,5405,5406,5407,5400],{|gq2|5390|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/wood-about-bg-150x150.jpg|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:150},|gq2|5396|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-1.png|gq2|,|gq2|width|gq2|:147,|gq2|height|gq2|:40},|gq2|5397|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-2-150x26.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:26},|gq2|5398|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-3-150x40.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:40},|gq2|5399|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-4.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:46},|gq2|5400|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-5.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:59},|gq2|5404|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-1.png|gq2|,|gq2|width|gq2|:147,|gq2|height|gq2|:58},|gq2|5405|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-2-150x59.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:59},|gq2|5406|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-3-150x58.png|gq2|,|gq2|width|gq2|:150,|gq2|height|gq2|:58},|gq2|5407|gq2|:{|gq2|title|gq2|:|gq2||gq2|,|gq2|caption|gq2|:|gq2||gq2|,|gq2|caption-position|gq2|:|gq2||gq2|,|gq2|slide-link|gq2|:|gq2||gq2|,|gq2|url|gq2|:|gq2||gq2|,|gq2|new-tab|gq2|:|gq2|enable|gq2|,|gq2|thumbnail|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/09/banner-4.png|gq2|,|gq2|width|gq2|:128,|gq2|height|gq2|:59}}]","thumbnail-size":"full","banner-columns":"5","margin-bottom":"20px"}}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"top","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"50px","padding-bottom":"15px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'service-2' => array(
					'above-sidebar'=>'[]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Title","type":"title","option":{"page-item-id":"","title-type":"center","title-size":"extra-large","title":"Our Services","caption":"Donec ullamcorper nulla non metus auctor","right-text":"Read All News","right-text-link":"","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"5475","background-mobile":"","background-speed":"0","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"145px","padding-bottom":"125px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5370","icon":"","title":"Commodo Fringilla Nibh","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5371","icon":"","title":"Mattis Sollicitudin","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5373","icon":"","title":"Ultricies Purus Tristique","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5372","icon":"","title":"Tristique Egestas Dolor","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5374","icon":"","title":"Amet Tristique Magna","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","type":"image","image":"5375","icon":"","title":"Ornare Cras Ultricies","style":"type-1","hover-bg":"","hover-text":"","content":"<p>Sed posuere consectetur est at lobortis. Etiam porta sem malesuada magna mollis euismod. Nulla vitae elit libero, a pharetra augue. Cras mattis consecte.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"45px"}}],"option":{},"size":"1/3"}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"totalbusiness-skin-light-grey","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"0px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Stunning Text","type":"stunning-text","option":{"page-item-id":"","style":"center","title":"It\'s The Best WordPress Theme.","caption":"This theme comes with many awesome features and it suits to any kind of businesses. You will love it!","button-text":"Learn More","button-link":"#","button2-text":"Buy Now!","button2-link":"#","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"5469","background-mobile":"","background-speed":"0","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"totalbusiness-skin-dark-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"135px","padding-bottom":"105px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"About Us","type":"about-us","option":{"page-item-id":"","style":"plain","caption":"","title":"Our Story","content":"<p>Donec ullamcorper nulla non metus auctor fringilla. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec id elit non mi porta gravida at eget metus. Donec id elit non mi porta gravida at eget metus. Cras mattis consectetur purus sit amet fermentum. Aenean eu leo quam.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"20px"}}],"option":{},"size":"1/2"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"About Us","type":"about-us","option":{"page-item-id":"","style":"plain","caption":"","title":"Our Vision","content":"<p>Donec ullamcorper nulla non metus auctor fringilla. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec id elit non mi porta gravida at eget metus. Donec id elit non mi porta gravida at eget metus. Cras mattis consectetur purus sit amet fermentum. Aenean eu leo quam.</p>","read-more-text":"Read More","read-more-link":"","margin-bottom":"20px"}}],"option":{},"size":"1/2"}],"option":{"page-item-id":"","background-type":"color","background":"#ffffff","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"75px","padding-bottom":"50px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'q-a' => array(
					'above-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[{"item-type":"item","item-builder-title":"Accordion","type":"accordion","option":{"page-item-id":"","accordion":"[{|gq2|gdl-tab-title|gq2|:|gq2|Bibendum Porta Fermentum?|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Donec sed odio dui. Maecenas sed diam eget risus varius blandit sit amet non magna. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Donec id elit non mi porta gravida at eget metus. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum.|g2n||g2n|<ul>|g2n|<li>Cras justo odio, dapibus ac facilisis in, egestas eget quam.</li>|g2n|<li>Etiam porta sem malesuada magna mollis euismod.</li>|g2n|<li>Aenean lacinia bibendum nulla sed consectetur.</li>|g2n|<li>Cras justo odio, dapibus ac facilisis in, egestas eget quam.</li>|g2n|</ul>|g2n||g2n|Etiam porta sem malesuada magna mollis euismod. Cras mattis consectetur purus sit amet fermentum. Donec sed odio dui. Curabitur blandit tempus porttitor. Nullam quis risus eget urna mollis ornare vel eu leo.|g2n||g2n|Nullam quis risus eget urna mollis ornare vel eu leo. Nulla vitae elit libero, a pharetra augue. Sed posuere consectetur est at lobortis. Curabitur blandit tempus porttitor. Maecenas sed diam eget risus varius blandit sit amet non magna. Nullam quis risus eget urna mollis ornare vel eu leo.|g2n||g2n|[gdlr_button href=|gq6|http://themeforest.net/user/GoodLayers|gq6| target=|gq6|_self|gq6| size=|gq6|small|gq6| background=|gq6|#f38142|gq6| color=|gq6|#ffffff|gq6|]Learn More[/gdlr_button]|gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Quam Elit Malesuada Magna?|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Donec sed odio dui. Maecenas sed diam eget risus varius blandit sit amet non magna. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Donec id elit non mi porta gravida at eget metus. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum.|g2n||g2n|<ul>|g2n|<li>Cras justo odio, dapibus ac facilisis in, egestas eget quam.</li>|g2n|<li>Etiam porta sem malesuada magna mollis euismod.</li>|g2n|<li>Aenean lacinia bibendum nulla sed consectetur.</li>|g2n|<li>Cras justo odio, dapibus ac facilisis in, egestas eget quam.</li>|g2n|</ul>|g2n||g2n|Etiam porta sem malesuada magna mollis euismod. Cras mattis consectetur purus sit amet fermentum. Donec sed odio dui. Curabitur blandit tempus porttitor. Nullam quis risus eget urna mollis ornare vel eu leo.|g2n||g2n|Nullam quis risus eget urna mollis ornare vel eu leo. Nulla vitae elit libero, a pharetra augue. Sed posuere consectetur est at lobortis. Curabitur blandit tempus porttitor. Maecenas sed diam eget risus varius blandit sit amet non magna. Nullam quis risus eget urna mollis ornare vel eu leo.|g2n||g2n|[gdlr_button href=|gq6|http://themeforest.net/user/GoodLayers|gq6| target=|gq6|_self|gq6| size=|gq6|small|gq6| background=|gq6|#f38142|gq6| color=|gq6|#ffffff|gq6|]Learn More[/gdlr_button]|gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Praesent commodo cursus magna, vel scelerisque nisl consectetur et?|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Donec sed odio dui. Maecenas sed diam eget risus varius blandit sit amet non magna. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Donec id elit non mi porta gravida at eget metus. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum.|g2n||g2n|<ul>|g2n|<li>Cras justo odio, dapibus ac facilisis in, egestas eget quam.</li>|g2n|<li>Etiam porta sem malesuada magna mollis euismod.</li>|g2n|<li>Aenean lacinia bibendum nulla sed consectetur.</li>|g2n|<li>Cras justo odio, dapibus ac facilisis in, egestas eget quam.</li>|g2n|</ul>|g2n||g2n|Etiam porta sem malesuada magna mollis euismod. Cras mattis consectetur purus sit amet fermentum. Donec sed odio dui. Curabitur blandit tempus porttitor. Nullam quis risus eget urna mollis ornare vel eu leo.|g2n||g2n|Nullam quis risus eget urna mollis ornare vel eu leo. Nulla vitae elit libero, a pharetra augue. Sed posuere consectetur est at lobortis. Curabitur blandit tempus porttitor. Maecenas sed diam eget risus varius blandit sit amet non magna. Nullam quis risus eget urna mollis ornare vel eu leo.|g2n||g2n|[gdlr_button href=|gq6|http://themeforest.net/user/GoodLayers|gq6| target=|gq6|_self|gq6| size=|gq6|small|gq6| background=|gq6|#f38142|gq6| color=|gq6|#ffffff|gq6|]Learn More[/gdlr_button]|gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Sem Purus Bibendum Pharetra?|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Donec sed odio dui. Maecenas sed diam eget risus varius blandit sit amet non magna. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Donec id elit non mi porta gravida at eget metus. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum.|g2n||g2n|<ul>|g2n|<li>Cras justo odio, dapibus ac facilisis in, egestas eget quam.</li>|g2n|<li>Etiam porta sem malesuada magna mollis euismod.</li>|g2n|<li>Aenean lacinia bibendum nulla sed consectetur.</li>|g2n|<li>Cras justo odio, dapibus ac facilisis in, egestas eget quam.</li>|g2n|</ul>|g2n||g2n|Etiam porta sem malesuada magna mollis euismod. Cras mattis consectetur purus sit amet fermentum. Donec sed odio dui. Curabitur blandit tempus porttitor. Nullam quis risus eget urna mollis ornare vel eu leo.|g2n||g2n|Nullam quis risus eget urna mollis ornare vel eu leo. Nulla vitae elit libero, a pharetra augue. Sed posuere consectetur est at lobortis. Curabitur blandit tempus porttitor. Maecenas sed diam eget risus varius blandit sit amet non magna. Nullam quis risus eget urna mollis ornare vel eu leo.|g2n||g2n|[gdlr_button href=|gq6|http://themeforest.net/user/GoodLayers|gq6| target=|gq6|_self|gq6| size=|gq6|small|gq6| background=|gq6|#f38142|gq6| color=|gq6|#ffffff|gq6|]Learn More[/gdlr_button]|gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Praesent commodo cursus magna, vel scelerisque nisl consectetur et?|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Donec sed odio dui. Maecenas sed diam eget risus varius blandit sit amet non magna. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Donec id elit non mi porta gravida at eget metus. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum.|g2n||g2n|<ul>|g2n|<li>Cras justo odio, dapibus ac facilisis in, egestas eget quam.</li>|g2n|<li>Etiam porta sem malesuada magna mollis euismod.</li>|g2n|<li>Aenean lacinia bibendum nulla sed consectetur.</li>|g2n|<li>Cras justo odio, dapibus ac facilisis in, egestas eget quam.</li>|g2n|</ul>|g2n||g2n|Etiam porta sem malesuada magna mollis euismod. Cras mattis consectetur purus sit amet fermentum. Donec sed odio dui. Curabitur blandit tempus porttitor. Nullam quis risus eget urna mollis ornare vel eu leo.|g2n||g2n|Nullam quis risus eget urna mollis ornare vel eu leo. Nulla vitae elit libero, a pharetra augue. Sed posuere consectetur est at lobortis. Curabitur blandit tempus porttitor. Maecenas sed diam eget risus varius blandit sit amet non magna. Nullam quis risus eget urna mollis ornare vel eu leo.|g2n||g2n|[gdlr_button href=|gq6|http://themeforest.net/user/GoodLayers|gq6| target=|gq6|_self|gq6| size=|gq6|small|gq6| background=|gq6|#f38142|gq6| color=|gq6|#ffffff|gq6|]Learn More[/gdlr_button]|gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Sollicitudin Fermentum Risus Commodo Nibh?|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Donec sed odio dui. Maecenas sed diam eget risus varius blandit sit amet non magna. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Donec id elit non mi porta gravida at eget metus. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum.|g2n||g2n|<ul>|g2n|<li>Cras justo odio, dapibus ac facilisis in, egestas eget quam.</li>|g2n|<li>Etiam porta sem malesuada magna mollis euismod.</li>|g2n|<li>Aenean lacinia bibendum nulla sed consectetur.</li>|g2n|<li>Cras justo odio, dapibus ac facilisis in, egestas eget quam.</li>|g2n|</ul>|g2n||g2n|Etiam porta sem malesuada magna mollis euismod. Cras mattis consectetur purus sit amet fermentum. Donec sed odio dui. Curabitur blandit tempus porttitor. Nullam quis risus eget urna mollis ornare vel eu leo.|g2n||g2n|Nullam quis risus eget urna mollis ornare vel eu leo. Nulla vitae elit libero, a pharetra augue. Sed posuere consectetur est at lobortis. Curabitur blandit tempus porttitor. Maecenas sed diam eget risus varius blandit sit amet non magna. Nullam quis risus eget urna mollis ornare vel eu leo.|g2n||g2n|[gdlr_button href=|gq6|http://themeforest.net/user/GoodLayers|gq6| target=|gq6|_self|gq6| size=|gq6|small|gq6| background=|gq6|#f38142|gq6| color=|gq6|#ffffff|gq6|]Learn More[/gdlr_button]|gq2|}]","title-type":"none","title-size":"small","title":"","caption":"","initial-state":"1","style":"style-1","margin-bottom":"60px"}}],"option":{},"size":"2/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-5","items":[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"left","title-size":"small","title":"Can\'t find answer? Ask Us.","caption":"","right-text":"Read All News","right-text-link":"","content":"<p>[contact-form-7 id=|gq2|5|gq2| title=|gq2|Contact Homepage|gq2|]</p>","margin-bottom":"20px"}}],"option":{},"size":"1/3"}]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","show-title":"enable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'personnel' => array(
					'above-sidebar'=>'[]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"item","item-builder-title":"Personnel","type":"personnel","option":{"page-item-id":"","personnel":"[{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/07/personnel-1.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|5440|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Paul Fisher|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Financial Advisor|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.|gq2|,|gq2|gdl-tab-social-list|gq2|:|gq2|[gdlr_icon type=|gq6|fa-facebook|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-twitter|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-linkedin|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-skype|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] |g2n|[gdlr_space height=|gq6|35px|gq6|]|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/07/personnel-6.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|5445|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|John Smith|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Business Planner|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.|gq2|,|gq2|gdl-tab-social-list|gq2|:|gq2|[gdlr_icon type=|gq6|fa-facebook|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-twitter|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-linkedin|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-skype|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] |g2n|[gdlr_space height=|gq6|35px|gq6|]|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/07/personnel-5.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|5444|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Simon Cruise|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Wealth Manager|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.|gq2|,|gq2|gdl-tab-social-list|gq2|:|gq2|[gdlr_icon type=|gq6|fa-facebook|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-twitter|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-linkedin|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-skype|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] |g2n|[gdlr_space height=|gq6|35px|gq6|]|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/07/personnel-4.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|5443|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Ricardo Silvia|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Human Relation|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.|gq2|,|gq2|gdl-tab-social-list|gq2|:|gq2|[gdlr_icon type=|gq6|fa-facebook|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-twitter|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-linkedin|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-skype|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] |g2n|[gdlr_space height=|gq6|35px|gq6|]|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/07/personnel-3.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|5442|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Jennifer Lopez|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Accountant|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.|gq2|,|gq2|gdl-tab-social-list|gq2|:|gq2|[gdlr_icon type=|gq6|fa-facebook|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-twitter|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-linkedin|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-skype|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] |g2n|[gdlr_space height=|gq6|35px|gq6|]|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://demo.goodlayers.com/totalbusiness/woodfactory/wp-content/uploads/2015/07/personnel-2.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|5441|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|John Doe|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Chief Financial Officer|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.|gq2|,|gq2|gdl-tab-social-list|gq2|:|gq2|[gdlr_icon type=|gq6|fa-facebook|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-twitter|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-linkedin|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] [gdlr_icon type=|gq6|fa-skype|gq6| size=|gq6|17px|gq6| color=|gq6|#999999|gq6|] |g2n|[gdlr_space height=|gq6|35px|gq6|]|gq2|}]","title-type":"none","title-size":"small","title":"","caption":"","personnel-columns":"3","personnel-type":"static","personnel-style":"plain-style","thumbnail-size":"blog-grid","margin-bottom":"40px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"left","title-size":"medium","title":"What We Are Good At","caption":"","right-text":"Read All News ?","right-text-link":"","content":"<p>Maecenas sed diam eget risus varius blandit sit amet non magna. Nulla vitae elit libero, a pharetra augue. Maecenas sed diam eget risus varius blandit sit amet non magna. Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Nulla vitae elit libero, a pharetra augue. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Integer posuere erat a ante venenatis dapibus.</p>","margin-bottom":"50px"}}],"option":{},"size":"1/2"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Business Planning","percent":"100","size":"small","icon":"","text-color":"#ffffff","background-color":"#e9e9e9","progress-color":"#36bddb","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Financial Advising","percent":"95","size":"small","icon":"","text-color":"#ffffff","background-color":"#e9e9e9","progress-color":"#36bddb","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Loaning","percent":"80","size":"small","icon":"","text-color":"#ffffff","background-color":"#e9e9e9","progress-color":"#36bddb","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Business IT","percent":"95","size":"small","icon":"","text-color":"#ffffff","background-color":"#e9e9e9","progress-color":"#36bddb","margin-bottom":"20px"}}],"option":{},"size":"1/2"}],"option":{"page-item-id":"","type":"image","background":"5439","background-mobile":"","background-speed":"0","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"totalbusiness-skin-dark-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"85px","padding-bottom":"40px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","show-title":"enable","page-caption":"Meet The Team","show-content":"enable","header-background":""}'
				),
				'contact-1' => array(
					'above-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Full Size Wrapper","type":"full-size-wrapper","items":[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","title-size":"small","title":"","caption":"","right-text":"Read All News","right-text-link":"","content":"<p>[put_wpgm id=1]</p>","margin-bottom":"0px"}}],"option":{"page-item-id":"","background":"#ffffff","show-section":"gdlr-show-all","border":"none","border-top-color":"#dddddd","border-bottom-color":"#dddddd","padding-top":"0px","padding-bottom":"0px"}}]',
					'below-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Box Icon","type":"box-icon-item","option":{"page-item-id":"","icon":"fa-envelope","icon-position":"top","icon-type":"circle","icon-color":"#ffffff","icon-background":"#36bddb","title":"Contact By Email","content":"<p>Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua.</p>","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Box Icon","type":"box-icon-item","option":{"page-item-id":"","icon":"fa-phone","icon-position":"top","icon-type":"circle","icon-color":"#ffffff","icon-background":"#36bddb","title":"Contact By Phone","content":"<p>Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua.</p>","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Box Icon","type":"box-icon-item","option":{"page-item-id":"","icon":"fa-home","icon-position":"top","icon-type":"circle","icon-color":"#ffffff","icon-background":"#36bddb","title":"Come To See Us","content":"<p>Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua.</p>","margin-bottom":"20px"}}],"option":{},"size":"1/3"}],"option":{"page-item-id":"","type":"image","background":"5257","background-mobile":"","background-speed":"0.2","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"no-skin","show-section":"gdlr-show-all","border":"none","border-top-color":"#dddddd","border-bottom-color":"#dddddd","padding-top":"100px","padding-bottom":"50px"}}]',
					'content-with-sidebar'=>'[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","title-size":"small","title":"","caption":"","right-text":"Read All News","right-text-link":"","content":"<p>[gdlr_space height=|gq2|-22px|gq2|] [gdlr_heading tag=|gq2|h5|gq2| font_weight=|gq2|bold|gq2| ]Please fulfil the form below. [/gdlr_heading] [gdlr_space height=|gq2|25px|gq2|] [contact-form-7 id=|gq2|5|gq2| title=|gq2|Contact form 1|gq2|]</p>","margin-bottom":"60px"}}]',
					'post-option'=>'{"sidebar":"right-sidebar","left-sidebar":"Footer 1","right-sidebar":"contact","page-style":"normal","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'contact-2' => array(
					'above-sidebar'=>'[]',
					'below-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Full Size Wrapper","type":"full-size-wrapper","items":[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","title-size":"","title":"","caption":"","right-text":"Read All News","right-text-link":"","content":"<p>[put_wpgm id=1]</p>","margin-bottom":"0px"}}],"option":{"page-item-id":"","background":"#ffffff","show-section":"gdlr-show-all","border":"none","border-top-color":"#d8d8d8","border-bottom-color":"#dddddd","padding-top":"0px","padding-bottom":"0px"}}]',
					'content-with-sidebar'=>'[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","title-size":"small","title":"","caption":"","right-text":"Read All News","right-text-link":"","content":"<p>[gdlr_space height=|gq2|-22px|gq2|] [gdlr_heading tag=|gq2|h5|gq2| font_weight=|gq2|bold|gq2| ]Please fulfil the form below.[/gdlr_heading] [gdlr_space height=|gq2|25px|gq2|] [contact-form-7 id=|gq2|5|gq2| title=|gq2|Contact form 1|gq2|]</p>","margin-bottom":"60px"}}]',
					'post-option'=>'{"sidebar":"left-sidebar","left-sidebar":"contact","right-sidebar":"contact","page-style":"normal","show-title":"enable","page-caption":"Aenean eu leo quam. Pellentesque ornare sem.","show-content":"enable","header-background":"","header-style":"default"}'
				),	
				// array(
				// 	'above-sidebar'=>'[]',
				// 	'below-sidebar'=>'[]',
				// 	'content-with-sidebar'=>'[]',
				// 	'post-option'=>''
				// ),				
			);

			$loaded_data = $default_data[$_POST['slug']];
			foreach( $loaded_data as $meta_key => $meta_value ){
				update_post_meta($_POST['post_id'], $meta_key, $meta_value);
			}
		}
	}
?>