<?php
	/*	
	*	Goodlayers Master Slider Support File
	*/
	
	// disable auto update
	add_filter( 'masterslider_disable_auto_update', '__return_true' );
	
	// add a new section to starter sections
	add_filter( 'masterslider_starter_sections', 'totalbusiness_add_ms_section' );	
	if( !function_exists('totalbusiness_add_ms_section') ){
		function totalbusiness_add_ms_section( $sections ){
		 
			array_unshift($sections, array(
				'id'    => 'totalbusiness_ms_starter',  // you should define unique id for each section
				'title' => esc_html__('Goodlayers Starter', 'totalbusiness'),   // a title for starter section
			));

			return $sections;
		}
	}
	
	add_filter( 'masterslider_starter_fields', 'totalbusiness_add_ms_slider' );
	if( !function_exists('totalbusiness_add_ms_slider') ){
		function totalbusiness_add_ms_slider( $starters ){
			$starters['totalbusiness_ms_starter'] = array(
				array(
					'label'     => esc_html__( 'Sample Slider Cafe', 'totalbusiness' ),
					'id'        => 'totalbusiness-sample-slider1',
					'slidertype'=> 'custom',
					'importdata'=> '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',
					'screenshot'=> get_template_directory_uri() . '/images/sample-slider.png',
					'selected' => false
				),
				array(
					'label'     => esc_html__( 'Sample Slider Coffee', 'totalbusiness' ),
					'id'        => 'totalbusiness-sample-slider2',
					'slidertype'=> 'custom',
					'importdata'=> 'eyJzbGlkZXJzX2RhdGEiOnsiMSI6eyJ0aXRsZSI6IkhvbWVwYWdlIC0gQ29mZmVlIFNob3AiLCJwYXJhbXMiOiJleUp0WlhSaElqcDdJbE5sZEhScGJtZHpJV2xrY3lJNklqRWlMQ0pUWlhSMGFXNW5jeUZ1WlhoMFNXUWlPaklzSWxOc2FXUmxJV2xrY3lJNklqRXNNeUlzSWxOc2FXUmxJVzVsZUhSSlpDSTZOQ3dpUTI5dWRISnZiQ0ZwWkhNaU9pSXhMRElpTENKRGIyNTBjbTlzSVc1bGVIUkpaQ0k2TXl3aVUzUjViR1VoYVdSeklqb2lNU3d5TERNc05DdzFMRFlzT0NJc0lsTjBlV3hsSVc1bGVIUkpaQ0k2T1N3aVJXWm1aV04wSVdsa2N5STZJakVzTWl3ekxEUXNOU3cyTERjc09DdzVMREV3TERFeExERXlMREUxTERFMklpd2lSV1ptWldOMElXNWxlSFJKWkNJNk1UY3NJa3hoZVdWeUlXbGtjeUk2SWpFc01pd3pMRFFzTlN3MkxEZ2lMQ0pNWVhsbGNpRnVaWGgwU1dRaU9qbDlMQ0pOVTFCaGJtVnNMbE5sZEhScGJtZHpJanA3SWpFaU9pSjdYQ0pwWkZ3aU9sd2lNVndpTEZ3aWMyNWhjSEJwYm1kY0lqcG1ZV3h6WlN4Y0ltNWhiV1ZjSWpwY0lraHZiV1Z3WVdkbElDMGdRMjltWm1WbElGTm9iM0JjSWl4Y0luZHBaSFJvWENJNk1URTBNQ3hjSW1obGFXZG9kRndpT2pneE1DeGNJbmR5WVhCd1pYSlhhV1IwYUZWdWFYUmNJanBjSW5CNFhDSXNYQ0poZFhSdlEzSnZjRndpT21aaGJITmxMRndpZEhsd1pWd2lPbHdpWTNWemRHOXRYQ0lzWENKemJHbGtaWEpKWkZ3aU9sd2lNVndpTEZ3aWJHRjViM1YwWENJNlhDSm1kV3hzZDJsa2RHaGNJaXhjSW1GMWRHOUlaV2xuYUhSY0lqcG1ZV3h6WlN4Y0luUnlWbWxsZDF3aU9sd2lZbUZ6YVdOY0lpeGNJbk53WldWa1hDSTZYQ0l5TUZ3aUxGd2ljM0JoWTJWY0lqcGNJakJjSWl4Y0luTjBZWEowWENJNlhDSXhYQ0lzWENKbmNtRmlRM1Z5YzI5eVhDSTZYQ0l4WENJc1hDSnpkMmx3WlZ3aU9tWmhiSE5sTEZ3aWJXOTFjMlZjSWpwbVlXeHpaU3hjSW5kb1pXVnNYQ0k2WENKY0lpeGNJbXRsZVdKdllYSmtYQ0k2ZEhKMVpTeGNJbUYxZEc5d2JHRjVYQ0k2ZEhKMVpTeGNJbXh2YjNCY0lqcDBjblZsTEZ3aWMyaDFabVpzWlZ3aU9sd2lYQ0lzWENKd2NtVnNiMkZrWENJNlhDSXRNVndpTEZ3aWIzWmxjbEJoZFhObFhDSTZYQ0l4WENJc1hDSmxibVJRWVhWelpWd2lPbHdpWENJc1hDSm9hV1JsVEdGNVpYSnpYQ0k2WENKY0lpeGNJbVJwY2x3aU9sd2lhRndpTEZ3aWNHRnlZV3hzWVhoTmIyUmxYQ0k2WENKdlptWmNJaXhjSW5WelpVUmxaWEJNYVc1clhDSTZabUZzYzJVc1hDSmtaV1Z3VEdsdWExd2lPbHdpYlhNdE1URmNJaXhjSW1SbFpYQk1hVzVyVkhsd1pWd2lPbHdpY0dGMGFGd2lMRndpYzJOeWIyeHNVR0Z5WVd4c1lYaE5iM1psWENJNk16QXNYQ0p6WTNKdmJHeFFZWEpoYkd4aGVFSkhUVzkyWlZ3aU9qVXdMRndpYzJOeWIyeHNVR0Z5WVd4c1lYaEdZV1JsWENJNmRISjFaU3hjSW1ObGJuUmxja052Ym5SeWIyeHpYQ0k2WENJeFhDSXNYQ0pwYm5OMFlXNTBVMmh2ZDB4aGVXVnljMXdpT2x3aVhDSXNYQ0pqYkdGemMwNWhiV1ZjSWpwY0lsd2lMRndpWW1kRGIyeHZjbHdpT2x3aUl6TTFNelV6TlZ3aUxGd2ljMnRwYmx3aU9sd2liWE10YzJ0cGJpMWtaV1poZFd4MFhDSXNYQ0p0YzFSbGJYQnNZWFJsWENJNlhDSmpkWE4wYjIxY0lpeGNJbTF6VkdWdGNHeGhkR1ZEYkdGemMxd2lPbHdpWENJc1hDSjFjMlZrUm05dWRITmNJanBjSWt4aGRHODZPVEF3WENKOUluMHNJazFUVUdGdVpXd3VVMnhwWkdVaU9uc2lNU0k2SW50Y0ltbGtYQ0k2WENJeFhDSXNYQ0owYVcxbGJHbHVaVjlvWENJNk1qQXdMRndpWW1kVWFIVnRZbHdpT2x3aUx6SXdNVFV2TURrdmMyeHBaR1Z5TFRFeExURTFNSGd4TlRBdWFuQm5YQ0lzWENKdmNtUmxjbHdpT2pBc1hDSmlaMXdpT2x3aUx6SXdNVFV2TURrdmMyeHBaR1Z5TFRFeExtcHdaMXdpTEZ3aVpIVnlZWFJwYjI1Y0lqbzNMRndpWm1sc2JFMXZaR1ZjSWpwY0ltWnBiR3hjSWl4Y0ltSm5kbDltYVd4c2JXOWtaVndpT2x3aVptbHNiRndpTEZ3aVltZDJYMnh2YjNCY0lqcGNJakZjSWl4Y0ltSm5kbDl0ZFhSbFhDSTZYQ0l4WENJc1hDSmlaM1pmWVhWMGIzQmhkWE5sWENJNlhDSmNJaXhjSW1KblFXeDBYQ0k2WENKY0lpeGNJbXhoZVdWeVgybGtjMXdpT2x0Y0lqRmNJaXd5TERNc09GMTlJaXdpTXlJNkludGNJbWxrWENJNk15eGNJblJwYldWc2FXNWxYMmhjSWpveU1EQXNYQ0ppWjFSb2RXMWlYQ0k2WENJdk1qQXhOUzh3T1M5emJHbGtaWEl0TWpFdE1UVXdlREUxTUM1cWNHZGNJaXhjSW05eVpHVnlYQ0k2TVN4Y0ltSm5YQ0k2WENJdk1qQXhOUzh3T1M5emJHbGtaWEl0TWpFdWFuQm5YQ0lzWENKa2RYSmhkR2x2Ymx3aU9qY3NYQ0ptYVd4c1RXOWtaVndpT2x3aVptbHNiRndpTEZ3aVltZDJYMlpwYkd4dGIyUmxYQ0k2WENKbWFXeHNYQ0lzWENKaVozWmZiRzl2Y0Z3aU9sd2lNVndpTEZ3aVltZDJYMjExZEdWY0lqcGNJakZjSWl4Y0ltSm5kbDloZFhSdmNHRjFjMlZjSWpwY0lsd2lMRndpWW1kQmJIUmNJanBjSWx3aUxGd2liR0Y1WlhKZmFXUnpYQ0k2V3pRc05TdzJYWDBpZlN3aVRWTlFZVzVsYkM1RGIyNTBjbTlzSWpwN0lqRWlPaUo3WENKcFpGd2lPbHdpTVZ3aUxGd2liR0ZpWld4Y0lqcGNJa0Z5Y205M2Mxd2lMRndpYm1GdFpWd2lPbHdpWVhKeWIzZHpYQ0lzWENKaGRYUnZTR2xrWlZ3aU9uUnlkV1VzWENKdmRtVnlWbWxrWlc5Y0lqcDBjblZsTEZ3aWFXNXpaWFJjSWpwMGNuVmxmU0lzSWpJaU9pSjdYQ0pwWkZ3aU9qSXNYQ0pzWVdKbGJGd2lPbHdpUW5Wc2JHVjBjMXdpTEZ3aWJtRnRaVndpT2x3aVluVnNiR1YwYzF3aUxGd2lZWFYwYjBocFpHVmNJanBtWVd4elpTeGNJbTkyWlhKV2FXUmxiMXdpT25SeWRXVXNYQ0p0WVhKbmFXNWNJam94TlN4Y0ltUnBjbHdpT2x3aWFGd2lMRndpYzNCaFkyVmNJam8yTEZ3aVlXeHBaMjVjSWpwY0ltSnZkSFJ2YlZ3aUxGd2lhVzV6WlhSY0lqcDBjblZsZlNKOUxDSk5VMUJoYm1Wc0xsTjBlV3hsSWpwN0lqRWlPaUo3WENKcFpGd2lPbHdpTVZ3aUxGd2lkSGx3WlZ3aU9sd2lZM1Z6ZEc5dFhDSXNYQ0pqYkdGemMwNWhiV1ZjSWpwY0ltMXpjQzFqYmkweExURmNJaXhjSW5CaFpHUnBibWRVYjNCY0lqb3hOU3hjSW5CaFpHUnBibWRTYVdkb2RGd2lPakkxTEZ3aWNHRmtaR2x1WjBKdmRIUnZiVndpT2pFMUxGd2ljR0ZrWkdsdVoweGxablJjSWpveU5TeGNJbUp2Y21SbGNsUnZjRndpT2pJc1hDSmliM0prWlhKU2FXZG9kRndpT2pJc1hDSmliM0prWlhKQ2IzUjBiMjFjSWpveUxGd2lZbTl5WkdWeVRHVm1kRndpT2pJc1hDSmliM0prWlhKVGRIbHNaVndpT2x3aWMyOXNhV1JjSWl4Y0ltWnZiblJYWldsbmFIUmNJanBjSW01dmNtMWhiRndpTEZ3aVptOXVkRk5wZW1WY0lqb3lOaXhjSW14cGJtVklaV2xuYUhSY0lqcGNJbTV2Y20xaGJGd2lMRndpWTI5c2IzSmNJanBjSWlObVptWm1abVpjSWl4Y0ltTjFjM1J2YlZ3aU9sd2labTl1ZEMxM1pXbG5hSFE2SURJd01EdGNYRzUwWlhoMExXRnNhV2R1T2lCalpXNTBaWEk3WENKOUlpd2lNaUk2SW50Y0ltbGtYQ0k2TWl4Y0luUjVjR1ZjSWpwY0ltTjFjM1J2YlZ3aUxGd2lZMnhoYzNOT1lXMWxYQ0k2WENKdGMzQXRZMjR0TVMweVhDSXNYQ0ptYjI1MFJtRnRhV3g1WENJNlhDSk1ZWFJ2WENJc1hDSm1iMjUwVjJWcFoyaDBYQ0k2WENJNU1EQmNJaXhjSW1admJuUlRhWHBsWENJNk9USXNYQ0pzWlhSMFpYSlRjR0ZqYVc1blhDSTZOQ3hjSW14cGJtVklaV2xuYUhSY0lqcGNJbTV2Y20xaGJGd2lMRndpWTI5c2IzSmNJanBjSWlObVptWm1abVpjSWl4Y0ltTjFjM1J2YlZ3aU9sd2labTl1ZEMxM1pXbG5hSFE2SURnd01EdGNYRzUwWlhoMExYUnlZVzV6Wm05eWJUb2dkWEJ3WlhKallYTmxPMXdpZlNJc0lqTWlPaUo3WENKcFpGd2lPak1zWENKbWIyNTBWMlZwWjJoMFhDSTZYQ0p1YjNKdFlXeGNJaXhjSW14cGJtVklaV2xuYUhSY0lqcGNJbTV2Y20xaGJGd2lmU0lzSWpRaU9pSjdYQ0pwWkZ3aU9qUXNYQ0owZVhCbFhDSTZYQ0pqZFhOMGIyMWNJaXhjSW1Oc1lYTnpUbUZ0WlZ3aU9sd2liWE53TFdOdUxURXRORndpTEZ3aVptOXVkRmRsYVdkb2RGd2lPbHdpYm05eWJXRnNYQ0lzWENKbWIyNTBVMmw2WlZ3aU9qTXdMRndpYkdsdVpVaGxhV2RvZEZ3aU9sd2libTl5YldGc1hDSXNYQ0pqYjJ4dmNsd2lPbHdpSTJabVptWm1abHdpTEZ3aVkzVnpkRzl0WENJNlhDSmNJbjBpTENJMUlqb2llMXdpYVdSY0lqbzFMRndpZEhsd1pWd2lPbHdpWTNWemRHOXRYQ0lzWENKamJHRnpjMDVoYldWY0lqcGNJbTF6Y0MxamJpMHhMVFZjSWl4Y0ltWnZiblJHWVcxcGJIbGNJanBjSWt4aGRHOWNJaXhjSW1admJuUlhaV2xuYUhSY0lqcGNJamt3TUZ3aUxGd2labTl1ZEZOcGVtVmNJam94TVRNc1hDSnNhVzVsU0dWcFoyaDBYQ0k2WENKdWIzSnRZV3hjSWl4Y0ltTnZiRzl5WENJNlhDSWpabVptWm1abVhDSXNYQ0pqZFhOMGIyMWNJanBjSW1admJuUXRkMlZwWjJoME9pQTRNREE3WENKOUlpd2lOaUk2SW50Y0ltbGtYQ0k2Tml4Y0ltWnZiblJYWldsbmFIUmNJanBjSW01dmNtMWhiRndpTEZ3aWJHbHVaVWhsYVdkb2RGd2lPbHdpYm05eWJXRnNYQ0o5SWl3aU9DSTZJbnRjSW1sa1hDSTZPQ3hjSW1admJuUlhaV2xuYUhSY0lqcGNJbTV2Y20xaGJGd2lMRndpYkdsdVpVaGxhV2RvZEZ3aU9sd2libTl5YldGc1hDSjlJbjBzSWsxVFVHRnVaV3d1UldabVpXTjBJanA3SWpFaU9pSjdYQ0pwWkZ3aU9sd2lNVndpTEZ3aVptRmtaVndpT25SeWRXVXNYQ0owY21GdWMyeGhkR1ZhWENJNk5UQXdmU0lzSWpJaU9pSjdYQ0pwWkZ3aU9qSXNYQ0ptWVdSbFhDSTZkSEoxWlgwaUxDSXpJam9pZTF3aWFXUmNJam96TEZ3aVptRmtaVndpT25SeWRXVXNYQ0owY21GdWMyeGhkR1ZhWENJNk5UQXdmU0lzSWpRaU9pSjdYQ0pwWkZ3aU9qUXNYQ0ptWVdSbFhDSTZkSEoxWlgwaUxDSTFJam9pZTF3aWFXUmNJam8xTEZ3aVptRmtaVndpT25SeWRXVjlJaXdpTmlJNkludGNJbWxrWENJNk5peGNJbVpoWkdWY0lqcDBjblZsZlNJc0lqY2lPaUo3WENKcFpGd2lPamNzWENKbVlXUmxYQ0k2ZEhKMVpTeGNJblJ5WVc1emJHRjBaVnBjSWpvMU1EQjlJaXdpT0NJNkludGNJbWxrWENJNk9DeGNJbVpoWkdWY0lqcDBjblZsZlNJc0lqa2lPaUo3WENKcFpGd2lPamtzWENKbVlXUmxYQ0k2ZEhKMVpTeGNJblJ5WVc1emJHRjBaVnBjSWpvdE5UQXdmU0lzSWpFd0lqb2llMXdpYVdSY0lqb3hNQ3hjSW1aaFpHVmNJanAwY25WbGZTSXNJakV4SWpvaWUxd2lhV1JjSWpveE1TeGNJbVpoWkdWY0lqcDBjblZsZlNJc0lqRXlJam9pZTF3aWFXUmNJam94TWl4Y0ltWmhaR1ZjSWpwMGNuVmxmU0lzSWpFMUlqb2llMXdpYVdSY0lqb3hOU3hjSW1aaFpHVmNJanAwY25WbGZTSXNJakUySWpvaWUxd2lhV1JjSWpveE5peGNJbVpoWkdWY0lqcDBjblZsZlNKOUxDSk5VMUJoYm1Wc0xreGhlV1Z5SWpwN0lqRWlPaUo3WENKcFpGd2lPbHdpTVZ3aUxGd2libUZ0WlZ3aU9sd2liR0Y1WlhKY0lpeGNJbWx6VEc5amEyVmtYQ0k2Wm1Gc2MyVXNYQ0pwYzBocFpHVmtYQ0k2Wm1Gc2MyVXNYQ0pwYzFOdmJHOWxaRndpT21aaGJITmxMRndpYzJodmQxUnlZVzV6Wm05eWJWd2lPbHdpY0dWeWMzQmxZM1JwZG1Vb01qQXdNSEI0S1NCMGNtRnVjMnhoZEdWYUtEVXdNSEI0S1Z3aUxGd2ljMmh2ZDA5eWFXZHBibHdpT2x3aU5UQWxJRFV3SlNBd2NIaGNJaXhjSW5Ob2IzZEdZV1JsWENJNmRISjFaU3hjSW1ocFpHVlVjbUZ1YzJadmNtMWNJanBjSWx3aUxGd2lhR2xrWlU5eWFXZHBibHdpT2x3aVhDSXNYQ0pvYVdSbFJtRmtaVndpT25SeWRXVXNYQ0p6ZEdGblpVOW1abk5sZEZoY0lqb3dMRndpYzNSaFoyVlBabVp6WlhSWlhDSTZNQ3hjSW05eVpHVnlYQ0k2TUN4Y0luUjVjR1ZjSWpwY0luUmxlSFJjSWl4Y0luQnZjMmwwYVc5dVhDSTZYQ0p1YjNKdFlXeGNJaXhjSW01dlUzZHBjR1ZjSWpwbVlXeHpaU3hjSW1OdmJuUmxiblJjSWpwY0lsZGxJR0Z5WlNCdmJtVWdiMllnZEdobElHSmxjM1FnWTI5bVptVmxJSE5vYjNBZ2FXNGdWVzVwZEdWa0lFdHBibWRrYjIwdUlEeGljaUF2UGxkbElHaGhkbVVnYlc5eVpTQjBhR0Z1SURJd01DQmljbUZ1WTJobGN5NWNJaXhjSW5acFpHVnZYQ0k2WENKb2RIUndPaTh2Y0d4aGVXVnlMblpwYldWdkxtTnZiUzkyYVdSbGJ5OHhNVGN5TVRJME1sd2lMRndpWVd4cFoyNWNJanBjSW5SdmNGd2lMRndpZFhObFFXTjBhVzl1WENJNlptRnNjMlVzWENKelkzSnZiR3hFZFhKaGRHbHZibHdpT2pJc1hDSnZabVp6WlhSWVhDSTZNQ3hjSW05bVpuTmxkRmxjSWpveE1UQXNYQ0ozYVdSMGFGd2lPalkyT0N4Y0luSmxjMmw2WlZ3aU9uUnlkV1VzWENKbWFYaGxaRndpT21aaGJITmxMRndpZDJsa2RHaHNhVzFwZEZ3aU9sd2lNRndpTEZ3aWIzSnBaMmx1WENJNlhDSnRZMXdpTEZ3aWMzUmhlVWh2ZG1WeVhDSTZkSEoxWlN4Y0ltTnNZWE56VG1GdFpWd2lPbHdpYlhOd0xXTnVMVEV0TVZ3aUxGd2ljMmh2ZDBSMWNtRjBhVzl1WENJNk1DNHpPRGMxTEZ3aWMyaHZkMFJsYkdGNVhDSTZNQ3hjSW5Ob2IzZEZZWE5sWENJNlhDSmxZWE5sVDNWMFVYVnBiblJjSWl4Y0luTm9iM2RGWm1aR2RXNWpYQ0k2WENKMEtIUnlkV1VzYml4dUxEVXdNQ3h1TEc0c2JpeHVMRzRzYml4dUxHNHNiaXh1TEc0cFhDSXNYQ0oxYzJWSWFXUmxYQ0k2Wm1Gc2MyVXNYQ0pvYVdSbFJIVnlZWFJwYjI1Y0lqb3hMRndpYUdsa1pVUmxiR0Y1WENJNk1TeGNJbWhwWkdWRllYTmxYQ0k2WENKbFlYTmxUM1YwVVhWcGJuUmNJaXhjSW1KMGJrTnNZWE56WENJNlhDSnRjeTFpZEc0Z2JYTXRaR1ZtWVhWc2RDMWlkRzVjSWl4Y0luTnNhV1JsWENJNlhDSXhYQ0lzWENKemRIbHNaVTF2WkdWc1hDSTZYQ0l4WENJc1hDSnphRzkzUldabVpXTjBYQ0k2WENJeFhDSXNYQ0pvYVdSbFJXWm1aV04wWENJNk1uMGlMQ0l5SWpvaWUxd2lhV1JjSWpveUxGd2libUZ0WlZ3aU9sd2liR0Y1WlhKY0lpeGNJbWx6VEc5amEyVmtYQ0k2Wm1Gc2MyVXNYQ0pwYzBocFpHVmtYQ0k2Wm1Gc2MyVXNYQ0pwYzFOdmJHOWxaRndpT21aaGJITmxMRndpYzJodmQxUnlZVzV6Wm05eWJWd2lPbHdpY0dWeWMzQmxZM1JwZG1Vb01qQXdNSEI0S1NCMGNtRnVjMnhoZEdWYUtEVXdNSEI0S1Z3aUxGd2ljMmh2ZDA5eWFXZHBibHdpT2x3aU5UQWxJRFV3SlNBd2NIaGNJaXhjSW5Ob2IzZEdZV1JsWENJNmRISjFaU3hjSW1ocFpHVlVjbUZ1YzJadmNtMWNJanBjSWx3aUxGd2lhR2xrWlU5eWFXZHBibHdpT2x3aVhDSXNYQ0pvYVdSbFJtRmtaVndpT25SeWRXVXNYQ0p6ZEdGblpVOW1abk5sZEZoY0lqb3dMRndpYzNSaFoyVlBabVp6WlhSWlhDSTZNQ3hjSW05eVpHVnlYQ0k2TVN4Y0luUjVjR1ZjSWpwY0luUmxlSFJjSWl4Y0luQnZjMmwwYVc5dVhDSTZYQ0p1YjNKdFlXeGNJaXhjSW01dlUzZHBjR1ZjSWpwbVlXeHpaU3hjSW1OdmJuUmxiblJjSWpwY0lsUm9aU0JEYjJabVpXVWdVMmh2Y0Z3aUxGd2lkbWxrWlc5Y0lqcGNJbWgwZEhBNkx5OXdiR0Y1WlhJdWRtbHRaVzh1WTI5dEwzWnBaR1Z2THpFeE56SXhNalF5WENJc1hDSmhiR2xuYmx3aU9sd2lkRzl3WENJc1hDSjFjMlZCWTNScGIyNWNJanBtWVd4elpTeGNJbk5qY205c2JFUjFjbUYwYVc5dVhDSTZNaXhjSW05bVpuTmxkRmhjSWpvd0xGd2liMlptYzJWMFdWd2lPaTAzTUM0MUxGd2ljbVZ6YVhwbFhDSTZkSEoxWlN4Y0ltWnBlR1ZrWENJNlptRnNjMlVzWENKM2FXUjBhR3hwYldsMFhDSTZYQ0l3WENJc1hDSnZjbWxuYVc1Y0lqcGNJbTFqWENJc1hDSnpkR0Y1U0c5MlpYSmNJanAwY25WbExGd2lZMnhoYzNOT1lXMWxYQ0k2WENKdGMzQXRZMjR0TVMweVhDSXNYQ0p6YUc5M1JIVnlZWFJwYjI1Y0lqb3dMak00TnpVc1hDSnphRzkzUkdWc1lYbGNJam93TGpNNE56VXNYQ0p6YUc5M1JXRnpaVndpT2x3aVpXRnpaVTkxZEZGMWFXNTBYQ0lzWENKemFHOTNSV1ptUm5WdVkxd2lPbHdpZENoMGNuVmxMRzRzYml3MU1EQXNiaXh1TEc0c2JpeHVMRzRzYml4dUxHNHNiaXh1S1Z3aUxGd2lkWE5sU0dsa1pWd2lPbVpoYkhObExGd2lhR2xrWlVSMWNtRjBhVzl1WENJNk1TeGNJbWhwWkdWRVpXeGhlVndpT2pFc1hDSm9hV1JsUldGelpWd2lPbHdpWldGelpVOTFkRkYxYVc1MFhDSXNYQ0ppZEc1RGJHRnpjMXdpT2x3aWJYTXRZblJ1SUcxekxXUmxabUYxYkhRdFluUnVYQ0lzWENKemJHbGtaVndpT2x3aU1Wd2lMRndpYzNSNWJHVk5iMlJsYkZ3aU9qSXNYQ0p6YUc5M1JXWm1aV04wWENJNk15eGNJbWhwWkdWRlptWmxZM1JjSWpvMGZTSXNJak1pT2lKN1hDSnBaRndpT2pNc1hDSnVZVzFsWENJNlhDSnNZWGxsY2x3aUxGd2lhWE5NYjJOclpXUmNJanBtWVd4elpTeGNJbWx6U0dsa1pXUmNJanBtWVd4elpTeGNJbWx6VTI5c2IyVmtYQ0k2Wm1Gc2MyVXNYQ0p6YUc5M1ZISmhibk5tYjNKdFhDSTZYQ0pjSWl4Y0luTm9iM2RQY21sbmFXNWNJanBjSWx3aUxGd2ljMmh2ZDBaaFpHVmNJanAwY25WbExGd2lhR2xrWlZSeVlXNXpabTl5YlZ3aU9sd2lYQ0lzWENKb2FXUmxUM0pwWjJsdVhDSTZYQ0pjSWl4Y0ltaHBaR1ZHWVdSbFhDSTZkSEoxWlN4Y0luTjBZV2RsVDJabWMyVjBXRndpT2pBc1hDSnpkR0ZuWlU5bVpuTmxkRmxjSWpvd0xGd2liM0prWlhKY0lqb3lMRndpZEhsd1pWd2lPbHdpWW5WMGRHOXVYQ0lzWENKd2IzTnBkR2x2Ymx3aU9sd2libTl5YldGc1hDSXNYQ0p1YjFOM2FYQmxYQ0k2Wm1Gc2MyVXNYQ0pqYjI1MFpXNTBYQ0k2WENKTVpXRnliaUJOYjNKbFhDSXNYQ0oyYVdSbGIxd2lPbHdpYUhSMGNEb3ZMM0JzWVhsbGNpNTJhVzFsYnk1amIyMHZkbWxrWlc4dk1URTNNakV5TkRKY0lpeGNJbUZzYVdkdVhDSTZYQ0owYjNCY0lpeGNJblZ6WlVGamRHbHZibHdpT21aaGJITmxMRndpYkdsdWExd2lPbHdpSTF3aUxGd2ljMk55YjJ4c1JIVnlZWFJwYjI1Y0lqb3lMRndpYjJabWMyVjBXRndpT2pBc1hDSnZabVp6WlhSWlhDSTZNak15TEZ3aWNtVnphWHBsWENJNmRISjFaU3hjSW1acGVHVmtYQ0k2Wm1Gc2MyVXNYQ0ozYVdSMGFHeHBiV2wwWENJNlhDSXdYQ0lzWENKdmNtbG5hVzVjSWpwY0ltMWpYQ0lzWENKemRHRjVTRzkyWlhKY0lqcDBjblZsTEZ3aWMyaHZkMFIxY21GMGFXOXVYQ0k2TUM0ME16YzFMRndpYzJodmQwUmxiR0Y1WENJNk1DNDRMRndpYzJodmQwVmhjMlZjSWpwY0ltVmhjMlZQZFhSUmRXbHVkRndpTEZ3aWRYTmxTR2xrWlZ3aU9tWmhiSE5sTEZ3aWFHbGtaVVIxY21GMGFXOXVYQ0k2TVN4Y0ltaHBaR1ZFWld4aGVWd2lPakVzWENKb2FXUmxSV0Z6WlZ3aU9sd2laV0Z6WlU5MWRGRjFhVzUwWENJc1hDSmlkRzVEYkdGemMxd2lPbHdpYlhNdFluUnVJRzF6TFdKMGJpMXliM1Z1WkNCdGN5MWlkRzR0YmlCdGMzQXRjSEpsYzJWMExXSjBiaTB4TlRsY0lpeGNJbk5zYVdSbFhDSTZYQ0l4WENJc1hDSnpkSGxzWlUxdlpHVnNYQ0k2TXl4Y0luTm9iM2RGWm1abFkzUmNJam8xTEZ3aWFHbGtaVVZtWm1WamRGd2lPalo5SWl3aU5DSTZJbnRjSW1sa1hDSTZOQ3hjSW01aGJXVmNJanBjSW14aGVXVnlYQ0lzWENKcGMweHZZMnRsWkZ3aU9tWmhiSE5sTEZ3aWFYTklhV1JsWkZ3aU9tWmhiSE5sTEZ3aWFYTlRiMnh2WldSY0lqcG1ZV3h6WlN4Y0luTm9iM2RVY21GdWMyWnZjbTFjSWpwY0luQmxjbk53WldOMGFYWmxLREl3TURCd2VDa2dkSEpoYm5Oc1lYUmxXaWcxTURCd2VDbGNJaXhjSW5Ob2IzZFBjbWxuYVc1Y0lqcGNJalV3SlNBMU1DVWdNSEI0WENJc1hDSnphRzkzUm1Ga1pWd2lPblJ5ZFdVc1hDSm9hV1JsVkhKaGJuTm1iM0p0WENJNlhDSmNJaXhjSW1ocFpHVlBjbWxuYVc1Y0lqcGNJbHdpTEZ3aWFHbGtaVVpoWkdWY0lqcDBjblZsTEZ3aWMzUmhaMlZQWm1aelpYUllYQ0k2TUN4Y0luTjBZV2RsVDJabWMyVjBXVndpT2pBc1hDSnZjbVJsY2x3aU9qRXNYQ0owZVhCbFhDSTZYQ0owWlhoMFhDSXNYQ0p3YjNOcGRHbHZibHdpT2x3aWJtOXliV0ZzWENJc1hDSnViMU4zYVhCbFhDSTZabUZzYzJVc1hDSmpiMjUwWlc1MFhDSTZYQ0pVYnlCVWFHVWdRMjltWm1WbElGTm9iM0JjSWl4Y0luWnBaR1Z2WENJNlhDSm9kSFJ3T2k4dmNHeGhlV1Z5TG5acGJXVnZMbU52YlM5MmFXUmxieTh4TVRjeU1USTBNbHdpTEZ3aVlXeHBaMjVjSWpwY0luUnZjRndpTEZ3aWRYTmxRV04wYVc5dVhDSTZabUZzYzJVc1hDSnpZM0p2Ykd4RWRYSmhkR2x2Ymx3aU9qSXNYQ0p2Wm1aelpYUllYQ0k2TUN4Y0ltOW1abk5sZEZsY0lqb3pPQzQxTEZ3aWNtVnphWHBsWENJNmRISjFaU3hjSW1acGVHVmtYQ0k2Wm1Gc2MyVXNYQ0ozYVdSMGFHeHBiV2wwWENJNlhDSXdYQ0lzWENKdmNtbG5hVzVjSWpwY0ltMXNYQ0lzWENKemRHRjVTRzkyWlhKY0lqcDBjblZsTEZ3aVkyeGhjM05PWVcxbFhDSTZYQ0p0YzNBdFkyNHRNUzAwWENJc1hDSnphRzkzUkhWeVlYUnBiMjVjSWpvd0xqTTROelVzWENKemFHOTNSR1ZzWVhsY0lqb3dMalF5TlN4Y0luTm9iM2RGWVhObFhDSTZYQ0psWVhObFQzVjBVWFZwYm5SY0lpeGNJbk5vYjNkRlptWkdkVzVqWENJNlhDSjBLSFJ5ZFdVc2JpeHVMRFV3TUN4dUxHNHNiaXh1TEc0c2JpeHVMRzRzYml4dUxHNHBYQ0lzWENKMWMyVklhV1JsWENJNlptRnNjMlVzWENKb2FXUmxSSFZ5WVhScGIyNWNJam94TEZ3aWFHbGtaVVJsYkdGNVhDSTZNU3hjSW1ocFpHVkZZWE5sWENJNlhDSmxZWE5sVDNWMFVYVnBiblJjSWl4Y0ltSjBia05zWVhOelhDSTZYQ0p0Y3kxaWRHNGdiWE10WkdWbVlYVnNkQzFpZEc1Y0lpeGNJbk5zYVdSbFhDSTZiblZzYkN4Y0luTjBlV3hsVFc5a1pXeGNJam8wTEZ3aWMyaHZkMFZtWm1WamRGd2lPamNzWENKb2FXUmxSV1ptWldOMFhDSTZPSDBpTENJMUlqb2llMXdpYVdSY0lqbzFMRndpYm1GdFpWd2lPbHdpYkdGNVpYSmNJaXhjSW1selRHOWphMlZrWENJNlptRnNjMlVzWENKcGMwaHBaR1ZrWENJNlptRnNjMlVzWENKcGMxTnZiRzlsWkZ3aU9tWmhiSE5sTEZ3aWMyaHZkMVJ5WVc1elptOXliVndpT2x3aWNHVnljM0JsWTNScGRtVW9NakF3TUhCNEtTQjBjbUZ1YzJ4aGRHVmFLQzAxTURCd2VDbGNJaXhjSW5Ob2IzZFBjbWxuYVc1Y0lqcGNJalV3SlNBMU1DVWdNSEI0WENJc1hDSnphRzkzUm1Ga1pWd2lPblJ5ZFdVc1hDSm9hV1JsVkhKaGJuTm1iM0p0WENJNlhDSmNJaXhjSW1ocFpHVlBjbWxuYVc1Y0lqcGNJbHdpTEZ3aWFHbGtaVVpoWkdWY0lqcDBjblZsTEZ3aWMzUmhaMlZQWm1aelpYUllYQ0k2TUN4Y0luTjBZV2RsVDJabWMyVjBXVndpT2pBc1hDSnZjbVJsY2x3aU9qQXNYQ0owZVhCbFhDSTZYQ0owWlhoMFhDSXNYQ0p3YjNOcGRHbHZibHdpT2x3aWJtOXliV0ZzWENJc1hDSnViMU4zYVhCbFhDSTZabUZzYzJVc1hDSmpiMjUwWlc1MFhDSTZYQ0pYWld4amIyMWxYQ0lzWENKMmFXUmxiMXdpT2x3aWFIUjBjRG92TDNCc1lYbGxjaTUyYVcxbGJ5NWpiMjB2ZG1sa1pXOHZNVEUzTWpFeU5ESmNJaXhjSW1Gc2FXZHVYQ0k2WENKMGIzQmNJaXhjSW5WelpVRmpkR2x2Ymx3aU9tWmhiSE5sTEZ3aWMyTnliMnhzUkhWeVlYUnBiMjVjSWpveUxGd2liMlptYzJWMFdGd2lPakFzWENKdlptWnpaWFJaWENJNkxUVTNMRndpY21WemFYcGxYQ0k2ZEhKMVpTeGNJbVpwZUdWa1hDSTZabUZzYzJVc1hDSjNhV1IwYUd4cGJXbDBYQ0k2WENJd1hDSXNYQ0p2Y21sbmFXNWNJanBjSW0xc1hDSXNYQ0p6ZEdGNVNHOTJaWEpjSWpwMGNuVmxMRndpWTJ4aGMzTk9ZVzFsWENJNlhDSnRjM0F0WTI0dE1TMDFYQ0lzWENKemFHOTNSSFZ5WVhScGIyNWNJam93TGpNNE56VXNYQ0p6YUc5M1JHVnNZWGxjSWpvd0xGd2ljMmh2ZDBWaGMyVmNJanBjSW1WaGMyVlBkWFJSZFdsdWRGd2lMRndpYzJodmQwVm1aa1oxYm1OY0lqcGNJblFvZEhKMVpTeHVMRzRzTFRVd01DeHVMRzRzYml4dUxHNHNiaXh1TEc0c2JpeHVMRzRwWENJc1hDSjFjMlZJYVdSbFhDSTZabUZzYzJVc1hDSm9hV1JsUkhWeVlYUnBiMjVjSWpveExGd2lhR2xrWlVSbGJHRjVYQ0k2TVN4Y0ltaHBaR1ZGWVhObFhDSTZYQ0psWVhObFQzVjBVWFZwYm5SY0lpeGNJbUowYmtOc1lYTnpYQ0k2WENKdGN5MWlkRzRnYlhNdFpHVm1ZWFZzZEMxaWRHNWNJaXhjSW5Oc2FXUmxYQ0k2Ym5Wc2JDeGNJbk4wZVd4bFRXOWtaV3hjSWpvMUxGd2ljMmh2ZDBWbVptVmpkRndpT2prc1hDSm9hV1JsUldabVpXTjBYQ0k2TVRCOUlpd2lOaUk2SW50Y0ltbGtYQ0k2Tml4Y0ltNWhiV1ZjSWpwY0lteGhlV1Z5WENJc1hDSnBjMHh2WTJ0bFpGd2lPbVpoYkhObExGd2lhWE5JYVdSbFpGd2lPbVpoYkhObExGd2lhWE5UYjJ4dlpXUmNJanBtWVd4elpTeGNJbk5vYjNkVWNtRnVjMlp2Y20xY0lqcGNJbHdpTEZ3aWMyaHZkMDl5YVdkcGJsd2lPbHdpWENJc1hDSnphRzkzUm1Ga1pWd2lPblJ5ZFdVc1hDSm9hV1JsVkhKaGJuTm1iM0p0WENJNlhDSmNJaXhjSW1ocFpHVlBjbWxuYVc1Y0lqcGNJbHdpTEZ3aWFHbGtaVVpoWkdWY0lqcDBjblZsTEZ3aWMzUmhaMlZQWm1aelpYUllYQ0k2TUN4Y0luTjBZV2RsVDJabWMyVjBXVndpT2pBc1hDSnZjbVJsY2x3aU9qSXNYQ0owZVhCbFhDSTZYQ0ppZFhSMGIyNWNJaXhjSW5CdmMybDBhVzl1WENJNlhDSnViM0p0WVd4Y0lpeGNJbTV2VTNkcGNHVmNJanBtWVd4elpTeGNJbU52Ym5SbGJuUmNJanBjSWt4bFlYSnVJRTF2Y21WY0lpeGNJblpwWkdWdlhDSTZYQ0pvZEhSd09pOHZjR3hoZVdWeUxuWnBiV1Z2TG1OdmJTOTJhV1JsYnk4eE1UY3lNVEkwTWx3aUxGd2lZV3hwWjI1Y0lqcGNJblJ2Y0Z3aUxGd2lkWE5sUVdOMGFXOXVYQ0k2Wm1Gc2MyVXNYQ0pzYVc1clhDSTZYQ0lqWENJc1hDSnpZM0p2Ykd4RWRYSmhkR2x2Ymx3aU9qSXNYQ0p2Wm1aelpYUllYQ0k2TUN4Y0ltOW1abk5sZEZsY0lqb3hNVEVzWENKeVpYTnBlbVZjSWpwMGNuVmxMRndpWm1sNFpXUmNJanBtWVd4elpTeGNJbmRwWkhSb2JHbHRhWFJjSWpwY0lqQmNJaXhjSW05eWFXZHBibHdpT2x3aWJXeGNJaXhjSW5OMFlYbEliM1psY2x3aU9uUnlkV1VzWENKemFHOTNSSFZ5WVhScGIyNWNJam93TGpRek56VXNYQ0p6YUc5M1JHVnNZWGxjSWpvd0xqZ3NYQ0p6YUc5M1JXRnpaVndpT2x3aVpXRnpaVTkxZEZGMWFXNTBYQ0lzWENKMWMyVklhV1JsWENJNlptRnNjMlVzWENKb2FXUmxSSFZ5WVhScGIyNWNJam94TEZ3aWFHbGtaVVJsYkdGNVhDSTZNU3hjSW1ocFpHVkZZWE5sWENJNlhDSmxZWE5sVDNWMFVYVnBiblJjSWl4Y0ltSjBia05zWVhOelhDSTZYQ0p0Y3kxaWRHNGdiWE10WW5SdUxYSnZkVzVrSUcxekxXSjBiaTF1SUcxemNDMXdjbVZ6WlhRdFluUnVMVEUxT1Z3aUxGd2ljMnhwWkdWY0lqcHVkV3hzTEZ3aWMzUjViR1ZOYjJSbGJGd2lPallzWENKemFHOTNSV1ptWldOMFhDSTZNVEVzWENKb2FXUmxSV1ptWldOMFhDSTZNVEo5SWl3aU9DSTZJbnRjSW1sa1hDSTZPQ3hjSW01aGJXVmNJanBjSW14aGVXVnlYQ0lzWENKcGMweHZZMnRsWkZ3aU9tWmhiSE5sTEZ3aWFYTklhV1JsWkZ3aU9tWmhiSE5sTEZ3aWFYTlRiMnh2WldSY0lqcG1ZV3h6WlN4Y0luTm9iM2RVY21GdWMyWnZjbTFjSWpwY0lsd2lMRndpYzJodmQwOXlhV2RwYmx3aU9sd2lYQ0lzWENKemFHOTNSbUZrWlZ3aU9uUnlkV1VzWENKb2FXUmxWSEpoYm5ObWIzSnRYQ0k2WENKY0lpeGNJbWhwWkdWUGNtbG5hVzVjSWpwY0lsd2lMRndpYUdsa1pVWmhaR1ZjSWpwMGNuVmxMRndpYVcxblZHaDFiV0pjSWpwY0lpOHlNREUxTHpBNUwzTnNhV1JsY2kweExXUnBkbWxrWlhJdWFuQm5YQ0lzWENKemRHRm5aVTltWm5ObGRGaGNJam93TEZ3aWMzUmhaMlZQWm1aelpYUlpYQ0k2TUN4Y0ltOXlaR1Z5WENJNk15eGNJblI1Y0dWY0lqcGNJbWx0WVdkbFhDSXNYQ0p3YjNOcGRHbHZibHdpT2x3aWJtOXliV0ZzWENJc1hDSnViMU4zYVhCbFhDSTZabUZzYzJVc1hDSmpiMjUwWlc1MFhDSTZYQ0pNYjNKbGJTQkpjSE4xYlZ3aUxGd2lhVzFuWENJNlhDSXZNakF4TlM4d09TOXpiR2xrWlhJdE1TMWthWFpwWkdWeUxtcHdaMXdpTEZ3aWRtbGtaVzljSWpwY0ltaDBkSEE2THk5d2JHRjVaWEl1ZG1sdFpXOHVZMjl0TDNacFpHVnZMekV4TnpJeE1qUXlYQ0lzWENKaGJHbG5ibHdpT2x3aWRHOXdYQ0lzWENKMWMyVkJZM1JwYjI1Y0lqcG1ZV3h6WlN4Y0luTmpjbTlzYkVSMWNtRjBhVzl1WENJNk1peGNJbTltWm5ObGRGaGNJam95TEZ3aWIyWm1jMlYwV1Z3aU9qWXNYQ0p5WlhOcGVtVmNJanAwY25WbExGd2labWw0WldSY0lqcG1ZV3h6WlN4Y0luZHBaSFJvYkdsdGFYUmNJanBjSWpCY0lpeGNJbTl5YVdkcGJsd2lPbHdpYldOY0lpeGNJbk4wWVhsSWIzWmxjbHdpT25SeWRXVXNYQ0p6YUc5M1JIVnlZWFJwYjI1Y0lqb3dMalEzTlN4Y0luTm9iM2RFWld4aGVWd2lPakF1T0RFeU5TeGNJbk5vYjNkRllYTmxYQ0k2WENKbFlYTmxUM1YwVVhWcGJuUmNJaXhjSW5WelpVaHBaR1ZjSWpwbVlXeHpaU3hjSW1ocFpHVkVkWEpoZEdsdmJsd2lPakVzWENKb2FXUmxSR1ZzWVhsY0lqb3hMRndpYUdsa1pVVmhjMlZjSWpwY0ltVmhjMlZQZFhSUmRXbHVkRndpTEZ3aVluUnVRMnhoYzNOY0lqcGNJbTF6TFdKMGJpQnRjeTFrWldaaGRXeDBMV0owYmx3aUxGd2ljMnhwWkdWY0lqcGNJakZjSWl4Y0luTjBlV3hsVFc5a1pXeGNJam80TEZ3aWMyaHZkMFZtWm1WamRGd2lPakUxTEZ3aWFHbGtaVVZtWm1WamRGd2lPakUyZlNKOWZRPT0iLCJ0eXBlIjoiY3VzdG9tIiwic2xpZGVzX251bSI6IjIifX0sIm9yaWdpbl91cGxvYWRzX3VybCI6Imh0dHA6XC9cL2RlbW8uZ29vZGxheWVycy5jb21cL3RvdGFsYnVzaW5lc3NcL2NvZmZlZXNob3BcL3dwLWNvbnRlbnRcL3VwbG9hZHMiLCJwcmVzZXRfc3R5bGVzIjoiZXlKdFpYUmhJanA3ZlgwPSIsInByZXNldF9lZmZlY3RzIjoiZXlKdFpYUmhJanA3SWxCeVpYTmxkRVZtWm1WamRDRnBaSE1pT2lJMkxEY3NPQ3c1TERFd0xERXhMREV5TERFekxERTBMREUxTERFMkxERTNMREU0TERFNUxESXdMREl4TERJeUxESXpMREkwTERJMUxESTJMREkzTERJNExESTVMRE13TERNeElpd2lVSEpsYzJWMFJXWm1aV04wSVc1bGVIUkpaQ0k2TXpKOUxDSk5VMUJoYm1Wc0xsQnlaWE5sZEVWbVptVmpkQ0k2ZXlJMklqb2llMXdpYVdSY0lqbzJMRndpYm1GdFpWd2lPbHdpVW1sbmFIUWdjMmh2Y25SY0lpeGNJblI1Y0dWY0lqcGNJbkJ5WlhObGRGd2lMRndpWm1Ga1pWd2lPblJ5ZFdVc1hDSjBjbUZ1YzJ4aGRHVllYQ0k2TVRVd2ZTSXNJamNpT2lKN1hDSnBaRndpT2pjc1hDSnVZVzFsWENJNlhDSk1aV1owSUhOb2IzSjBYQ0lzWENKMGVYQmxYQ0k2WENKd2NtVnpaWFJjSWl4Y0ltWmhaR1ZjSWpwMGNuVmxMRndpZEhKaGJuTnNZWFJsV0Z3aU9pMHhOVEI5SWl3aU9DSTZJbnRjSW1sa1hDSTZPQ3hjSW01aGJXVmNJanBjSWxSdmNDQnphRzl5ZEZ3aUxGd2lkSGx3WlZ3aU9sd2ljSEpsYzJWMFhDSXNYQ0ptWVdSbFhDSTZkSEoxWlN4Y0luUnlZVzV6YkdGMFpWbGNJam90TVRVd2ZTSXNJamtpT2lKN1hDSnBaRndpT2prc1hDSnVZVzFsWENJNlhDSkNiM1IwYjIwZ2MyaHZjblJjSWl4Y0luUjVjR1ZjSWpwY0luQnlaWE5sZEZ3aUxGd2labUZrWlZ3aU9uUnlkV1VzWENKMGNtRnVjMnhoZEdWWlhDSTZNVFV3ZlNJc0lqRXdJam9pZTF3aWFXUmNJam94TUN4Y0ltNWhiV1ZjSWpwY0lsSnBaMmgwSUd4dmJtZGNJaXhjSW5SNWNHVmNJanBjSW5CeVpYTmxkRndpTEZ3aVptRmtaVndpT25SeWRXVXNYQ0owY21GdWMyeGhkR1ZZWENJNk5UQXdmU0lzSWpFeElqb2llMXdpYVdSY0lqb3hNU3hjSW01aGJXVmNJanBjSWt4bFpuUWdiRzl1WjF3aUxGd2lkSGx3WlZ3aU9sd2ljSEpsYzJWMFhDSXNYQ0ptWVdSbFhDSTZkSEoxWlN4Y0luUnlZVzV6YkdGMFpWaGNJam90TlRBd2ZTSXNJakV5SWpvaWUxd2lhV1JjSWpveE1peGNJbTVoYldWY0lqcGNJbFJ2Y0NCc2IyNW5YQ0lzWENKMGVYQmxYQ0k2WENKd2NtVnpaWFJjSWl4Y0ltWmhaR1ZjSWpwMGNuVmxMRndpZEhKaGJuTnNZWFJsV1Z3aU9pMDFNREI5SWl3aU1UTWlPaUo3WENKcFpGd2lPakV6TEZ3aWJtRnRaVndpT2x3aVFtOTBkRzl0SUd4dmJtZGNJaXhjSW5SNWNHVmNJanBjSW5CeVpYTmxkRndpTEZ3aVptRmtaVndpT25SeWRXVXNYQ0owY21GdWMyeGhkR1ZaWENJNk5UQXdmU0lzSWpFMElqb2llMXdpYVdSY0lqb3hOQ3hjSW01aGJXVmNJanBjSWpORUlFWnliMjUwSUhOb2IzSjBYQ0lzWENKMGVYQmxYQ0k2WENKd2NtVnpaWFJjSWl4Y0ltWmhaR1ZjSWpwMGNuVmxMRndpZEhKaGJuTnNZWFJsV2x3aU9qVXdNSDBpTENJeE5TSTZJbnRjSW1sa1hDSTZNVFVzWENKdVlXMWxYQ0k2WENJelJDQkNZV05ySUhOb2IzSjBYQ0lzWENKMGVYQmxYQ0k2WENKd2NtVnpaWFJjSWl4Y0ltWmhaR1ZjSWpwMGNuVmxMRndpZEhKaGJuTnNZWFJsV2x3aU9pMDFNREI5SWl3aU1UWWlPaUo3WENKcFpGd2lPakUyTEZ3aWJtRnRaVndpT2x3aU0wUWdSbkp2Ym5RZ2JHOXVaMXdpTEZ3aWRIbHdaVndpT2x3aWNISmxjMlYwWENJc1hDSm1ZV1JsWENJNmRISjFaU3hjSW5SeVlXNXpiR0YwWlZwY0lqb3hOVEF3ZlNJc0lqRTNJam9pZTF3aWFXUmNJam94Tnl4Y0ltNWhiV1ZjSWpwY0lqTkVJRUpoWTJzZ2JHOXVaMXdpTEZ3aWRIbHdaVndpT2x3aWNISmxjMlYwWENJc1hDSm1ZV1JsWENJNmRISjFaU3hjSW5SeVlXNXpiR0YwWlZwY0lqb3RNVFV3TUgwaUxDSXhPQ0k2SW50Y0ltbGtYQ0k2TVRnc1hDSnVZVzFsWENJNlhDSlNiM1JoZEdVZ01UZ3dYQ0lzWENKMGVYQmxYQ0k2WENKd2NtVnpaWFJjSWl4Y0ltWmhaR1ZjSWpwMGNuVmxMRndpY205MFlYUmxYQ0k2TVRnd2ZTSXNJakU1SWpvaWUxd2lhV1JjSWpveE9TeGNJbTVoYldWY0lqcGNJbEp2ZEdGMFpTQXpOakJjSWl4Y0luUjVjR1ZjSWpwY0luQnlaWE5sZEZ3aUxGd2labUZrWlZ3aU9uUnlkV1VzWENKeWIzUmhkR1ZjSWpvek5qQjlJaXdpTWpBaU9pSjdYQ0pwWkZ3aU9qSXdMRndpYm1GdFpWd2lPbHdpVW05MFlYUmxJRGt3WENJc1hDSjBlWEJsWENJNlhDSndjbVZ6WlhSY0lpeGNJbVpoWkdWY0lqcDBjblZsTEZ3aWNtOTBZWFJsWENJNk9UQjlJaXdpTWpFaU9pSjdYQ0pwWkZ3aU9qSXhMRndpYm1GdFpWd2lPbHdpVW05MFlYUmxJQzA1TUZ3aUxGd2lkSGx3WlZ3aU9sd2ljSEpsYzJWMFhDSXNYQ0ptWVdSbFhDSTZkSEoxWlN4Y0luSnZkR0YwWlZ3aU9pMDVNSDBpTENJeU1pSTZJbnRjSW1sa1hDSTZNaklzWENKdVlXMWxYQ0k2WENJelJDQlNiM1JoZEdVZ2JHVm1kRndpTEZ3aWRIbHdaVndpT2x3aWNISmxjMlYwWENJc1hDSm1ZV1JsWENJNmRISjFaU3hjSW5SeVlXNXpiR0YwWlZoY0lqb3RNalV3TEZ3aWNtOTBZWFJsV1Z3aU9qSTFNSDBpTENJeU15STZJbnRjSW1sa1hDSTZNak1zWENKdVlXMWxYQ0k2WENJelJDQlNiM1JoZEdVZ2NtbG5hSFJjSWl4Y0luUjVjR1ZjSWpwY0luQnlaWE5sZEZ3aUxGd2labUZrWlZ3aU9uUnlkV1VzWENKMGNtRnVjMnhoZEdWWVhDSTZNalV3TEZ3aWNtOTBZWFJsV1Z3aU9pMHlOVEI5SWl3aU1qUWlPaUo3WENKcFpGd2lPakkwTEZ3aWJtRnRaVndpT2x3aU0wUWdVbTkwWVhSbElIUnZjRndpTEZ3aWRIbHdaVndpT2x3aWNISmxjMlYwWENJc1hDSm1ZV1JsWENJNmRISjFaU3hjSW5SeVlXNXpiR0YwWlZsY0lqb3RNalV3TEZ3aWNtOTBZWFJsV0Z3aU9qRTFNSDBpTENJeU5TSTZJbnRjSW1sa1hDSTZNalVzWENKdVlXMWxYQ0k2WENJelJDQlNiM1JoZEdVZ1ltOTBkRzl0WENJc1hDSjBlWEJsWENJNlhDSndjbVZ6WlhSY0lpeGNJbVpoWkdWY0lqcDBjblZsTEZ3aWRISmhibk5zWVhSbFdWd2lPakkxTUN4Y0luSnZkR0YwWlZoY0lqb3RNVFV3ZlNJc0lqSTJJam9pZTF3aWFXUmNJam95Tml4Y0ltNWhiV1ZjSWpwY0lsTnJaWGNnYkdWbWRGd2lMRndpZEhsd1pWd2lPbHdpY0hKbGMyVjBYQ0lzWENKbVlXUmxYQ0k2ZEhKMVpTeGNJblJ5WVc1emJHRjBaVmhjSWpvdE1qVXdMRndpYzJ0bGQxaGNJam90TWpWOUlpd2lNamNpT2lKN1hDSnBaRndpT2pJM0xGd2libUZ0WlZ3aU9sd2lVMnRsZHlCeWFXZG9kRndpTEZ3aWRIbHdaVndpT2x3aWNISmxjMlYwWENJc1hDSm1ZV1JsWENJNmRISjFaU3hjSW5SeVlXNXpiR0YwWlZoY0lqb3lOVEFzWENKemEyVjNXRndpT2pJMWZTSXNJakk0SWpvaWUxd2lhV1JjSWpveU9DeGNJbTVoYldWY0lqcGNJbE5yWlhjZ2RHOXdYQ0lzWENKMGVYQmxYQ0k2WENKd2NtVnpaWFJjSWl4Y0ltWmhaR1ZjSWpwMGNuVmxMRndpZEhKaGJuTnNZWFJsV1Z3aU9pMHlOVEFzWENKemEyVjNXVndpT2kweU5YMGlMQ0l5T1NJNkludGNJbWxrWENJNk1qa3NYQ0p1WVcxbFhDSTZYQ0pUYTJWM0lHSnZkSFJ2YlZ3aUxGd2lkSGx3WlZ3aU9sd2ljSEpsYzJWMFhDSXNYQ0ptWVdSbFhDSTZkSEoxWlN4Y0luUnlZVzV6YkdGMFpWbGNJam95TlRBc1hDSnphMlYzV1Z3aU9pMHlOWDBpTENJek1DSTZJbnRjSW1sa1hDSTZNekFzWENKdVlXMWxYQ0k2WENKU2IzUmhkR1VnWm5KdmJuUmNJaXhjSW5SNWNHVmNJanBjSW5CeVpYTmxkRndpTEZ3aVptRmtaVndpT25SeWRXVXNYQ0owY21GdWMyeGhkR1ZhWENJNk1UVXdNQ3hjSW5KdmRHRjBaVndpT2pJMU1IMGlMQ0l6TVNJNkludGNJbWxrWENJNk16RXNYQ0p1WVcxbFhDSTZYQ0pTYjNSaGRHVWdZbUZqYTF3aUxGd2lkSGx3WlZ3aU9sd2ljSEpsYzJWMFhDSXNYQ0ptWVdSbFhDSTZkSEoxWlN4Y0luUnlZVzV6YkdGMFpWcGNJam90TVRVd01DeGNJbkp2ZEdGMFpWd2lPakkxTUgwaWZYMD0ifQ==',
					'screenshot'=> get_template_directory_uri() . '/images/sample-slider.png',
					'selected' => false
				),
				array(
					'label'     => esc_html__( 'Sample Slider Creative', 'totalbusiness' ),
					'id'        => 'totalbusiness-sample-slider3',
					'slidertype'=> 'custom',
					'importdata'=> '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',
					'screenshot'=> get_template_directory_uri() . '/images/sample-slider.png',
					'selected' => false
				),
				array(
					'label'     => esc_html__( 'Sample Slider Creative 2', 'totalbusiness' ),
					'id'        => 'totalbusiness-sample-slider4',
					'slidertype'=> 'custom',
					'importdata'=> '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',
					'screenshot'=> get_template_directory_uri() . '/images/sample-slider.png',
					'selected' => false
				),
				array(
					'label'     => esc_html__( 'Sample Slider Creative 3', 'totalbusiness' ),
					'id'        => 'totalbusiness-sample-slider5',
					'slidertype'=> 'custom',
					'importdata'=> 'eyJzbGlkZXJzX2RhdGEiOnsiMSI6eyJ0aXRsZSI6IkhvbWVwYWdlIC0gQ3JlYXRpdmUgMDMiLCJwYXJhbXMiOiJleUp0WlhSaElqcDdJbE5sZEhScGJtZHpJV2xrY3lJNklqRWlMQ0pUWlhSMGFXNW5jeUZ1WlhoMFNXUWlPaklzSWxOc2FXUmxJV2xrY3lJNklqRXNNeUlzSWxOc2FXUmxJVzVsZUhSSlpDSTZOQ3dpUTI5dWRISnZiQ0ZwWkhNaU9pSXhMRElpTENKRGIyNTBjbTlzSVc1bGVIUkpaQ0k2TXl3aVUzUjViR1VoYVdSeklqb2lNaXcwTERVc055dzRMRGtpTENKVGRIbHNaU0Z1WlhoMFNXUWlPakV3TENKRlptWmxZM1FoYVdSeklqb2lNeXcwTERjc09DdzVMREV3TERFekxERTBMREUxTERFMkxERTNMREU0SWl3aVJXWm1aV04wSVc1bGVIUkpaQ0k2TVRrc0lreGhlV1Z5SVdsa2N5STZJaklzTkN3MUxEY3NPQ3c1SWl3aVRHRjVaWEloYm1WNGRFbGtJam94TUgwc0lrMVRVR0Z1Wld3dVUyVjBkR2x1WjNNaU9uc2lNU0k2SW50Y0ltbGtYQ0k2WENJeFhDSXNYQ0p6Ym1Gd2NHbHVaMXdpT21aaGJITmxMRndpYm1GdFpWd2lPbHdpU0c5dFpYQmhaMlVnTFNCRGNtVmhkR2wyWlNBd00xd2lMRndpZDJsa2RHaGNJam94TVRRd0xGd2lhR1ZwWjJoMFhDSTZOekF3TEZ3aWQzSmhjSEJsY2xkcFpIUm9WVzVwZEZ3aU9sd2ljSGhjSWl4Y0ltRjFkRzlEY205d1hDSTZabUZzYzJVc1hDSjBlWEJsWENJNlhDSmpkWE4wYjIxY0lpeGNJbk5zYVdSbGNrbGtYQ0k2WENJeFhDSXNYQ0pzWVhsdmRYUmNJanBjSW1aMWJHeDNhV1IwYUZ3aUxGd2lZWFYwYjBobGFXZG9kRndpT21aaGJITmxMRndpZEhKV2FXVjNYQ0k2WENKaVlYTnBZMXdpTEZ3aWMzQmxaV1JjSWpwY0lqSXdYQ0lzWENKemNHRmpaVndpT2x3aU1Gd2lMRndpYzNSaGNuUmNJanBjSWpGY0lpeGNJbWR5WVdKRGRYSnpiM0pjSWpwY0lqRmNJaXhjSW5OM2FYQmxYQ0k2Wm1Gc2MyVXNYQ0p0YjNWelpWd2lPbVpoYkhObExGd2lkMmhsWld4Y0lqcGNJbHdpTEZ3aWEyVjVZbTloY21SY0lqcDBjblZsTEZ3aVlYVjBiM0JzWVhsY0lqcDBjblZsTEZ3aWJHOXZjRndpT25SeWRXVXNYQ0p6YUhWbVpteGxYQ0k2WENKY0lpeGNJbkJ5Wld4dllXUmNJanBjSWkweFhDSXNYQ0p2ZG1WeVVHRjFjMlZjSWpwY0lqRmNJaXhjSW1WdVpGQmhkWE5sWENJNlhDSmNJaXhjSW1ocFpHVk1ZWGxsY25OY0lqcGNJbHdpTEZ3aVpHbHlYQ0k2WENKb1hDSXNYQ0p3WVhKaGJHeGhlRTF2WkdWY0lqcGNJbTltWmx3aUxGd2lkWE5sUkdWbGNFeHBibXRjSWpwbVlXeHpaU3hjSW1SbFpYQk1hVzVyWENJNlhDSnRjeTB4TVZ3aUxGd2laR1ZsY0V4cGJtdFVlWEJsWENJNlhDSndZWFJvWENJc1hDSnpZM0p2Ykd4UVlYSmhiR3hoZUZ3aU9uUnlkV1VzWENKelkzSnZiR3hRWVhKaGJHeGhlRTF2ZG1WY0lqb3pNQ3hjSW5OamNtOXNiRkJoY21Gc2JHRjRRa2ROYjNabFhDSTZOVEFzWENKelkzSnZiR3hRWVhKaGJHeGhlRVpoWkdWY0lqcDBjblZsTEZ3aVkyVnVkR1Z5UTI5dWRISnZiSE5jSWpwY0lqRmNJaXhjSW1sdWMzUmhiblJUYUc5M1RHRjVaWEp6WENJNlhDSmNJaXhjSW1Oc1lYTnpUbUZ0WlZ3aU9sd2lYQ0lzWENKaVowTnZiRzl5WENJNlhDSWpNelV6TlRNMVhDSXNYQ0p6YTJsdVhDSTZYQ0p0Y3kxemEybHVMV1JsWm1GMWJIUmNJaXhjSW0xelZHVnRjR3hoZEdWY0lqcGNJbU4xYzNSdmJWd2lMRndpYlhOVVpXMXdiR0YwWlVOc1lYTnpYQ0k2WENKY0lpeGNJblZ6WldSR2IyNTBjMXdpT2x3aVRHRjBiem81TURBc01UQXdMRE13TUh4UGNHVnVLMU5oYm5NNmNtVm5kV3hoY2x3aWZTSjlMQ0pOVTFCaGJtVnNMbE5zYVdSbElqcDdJakVpT2lKN1hDSnBaRndpT2x3aU1Wd2lMRndpZEdsdFpXeHBibVZmYUZ3aU9qSXdNQ3hjSW1KblZHaDFiV0pjSWpwY0lpOHlNREUxTHpBNUwzTnNhV1JsY2kweExURTFNSGd4TlRBdWFuQm5YQ0lzWENKdmNtUmxjbHdpT2pFc1hDSmlaMXdpT2x3aUx6SXdNVFV2TURrdmMyeHBaR1Z5TFRFdWFuQm5YQ0lzWENKa2RYSmhkR2x2Ymx3aU9qY3NYQ0ptYVd4c1RXOWtaVndpT2x3aVptbHNiRndpTEZ3aVltZDJYMlpwYkd4dGIyUmxYQ0k2WENKbWFXeHNYQ0lzWENKaVozWmZiRzl2Y0Z3aU9sd2lNVndpTEZ3aVltZDJYMjExZEdWY0lqcGNJakZjSWl4Y0ltSm5kbDloZFhSdmNHRjFjMlZjSWpwY0lsd2lMRndpWW1kQmJIUmNJanBjSWx3aUxGd2liR0Y1WlhKZmFXUnpYQ0k2V3pJc09WMTlJaXdpTXlJNkludGNJbWxrWENJNk15eGNJblJwYldWc2FXNWxYMmhjSWpveU1EQXNYQ0ppWjFSb2RXMWlYQ0k2WENJdk1qQXhOUzh3T1M5d1lXZGxMWFJwZEd4bExXSm5MVEUxTUhneE5UQXVhbkJuWENJc1hDSnZjbVJsY2x3aU9qQXNYQ0ppWjF3aU9sd2lMekl3TVRVdk1Ea3ZjR0ZuWlMxMGFYUnNaUzFpWnk1cWNHZGNJaXhjSW1SMWNtRjBhVzl1WENJNk55eGNJbVpwYkd4TmIyUmxYQ0k2WENKbWFXeHNYQ0lzWENKaVozWmZabWxzYkcxdlpHVmNJanBjSW1acGJHeGNJaXhjSW1KbmRsOXNiMjl3WENJNlhDSXhYQ0lzWENKaVozWmZiWFYwWlZ3aU9sd2lNVndpTEZ3aVltZDJYMkYxZEc5d1lYVnpaVndpT2x3aVhDSXNYQ0ppWjBGc2RGd2lPbHdpWENJc1hDSnNZWGxsY2w5cFpITmNJanBiTkN3MUxEY3NPRjE5SW4wc0lrMVRVR0Z1Wld3dVEyOXVkSEp2YkNJNmV5SXhJam9pZTF3aWFXUmNJanBjSWpGY0lpeGNJbXhoWW1Wc1hDSTZYQ0pCY25KdmQzTmNJaXhjSW01aGJXVmNJanBjSW1GeWNtOTNjMXdpTEZ3aVlYVjBiMGhwWkdWY0lqcDBjblZsTEZ3aWIzWmxjbFpwWkdWdlhDSTZkSEoxWlN4Y0ltbHVjMlYwWENJNmRISjFaWDBpTENJeUlqb2llMXdpYVdSY0lqb3lMRndpYkdGaVpXeGNJanBjSWtKMWJHeGxkSE5jSWl4Y0ltNWhiV1ZjSWpwY0ltSjFiR3hsZEhOY0lpeGNJbUYxZEc5SWFXUmxYQ0k2Wm1Gc2MyVXNYQ0p2ZG1WeVZtbGtaVzljSWpwMGNuVmxMRndpYldGeVoybHVYQ0k2TVRVc1hDSmthWEpjSWpwY0ltaGNJaXhjSW5Od1lXTmxYQ0k2Tml4Y0ltRnNhV2R1WENJNlhDSmliM1IwYjIxY0lpeGNJbWx1YzJWMFhDSTZkSEoxWlgwaWZTd2lUVk5RWVc1bGJDNVRkSGxzWlNJNmV5SXlJam9pZTF3aWFXUmNJam95TEZ3aWRIbHdaVndpT2x3aVkzVnpkRzl0WENJc1hDSmpiR0Z6YzA1aGJXVmNJanBjSW0xemNDMWpiaTB4TFRKY0lpeGNJbVp2Ym5SR1lXMXBiSGxjSWpwY0lreGhkRzljSWl4Y0ltWnZiblJYWldsbmFIUmNJanBjSWprd01Gd2lMRndpWm05dWRGTnBlbVZjSWpvNE5TeGNJbXhsZEhSbGNsTndZV05wYm1kY0lqb3lMRndpYkdsdVpVaGxhV2RvZEZ3aU9sd2libTl5YldGc1hDSXNYQ0pqYjJ4dmNsd2lPbHdpSTJabVptWm1abHdpTEZ3aVkzVnpkRzl0WENJNlhDSm1iMjUwTFhkbGFXZG9kRG9nT0RBd08xeGNiblJsZUhRdGRISmhibk5tYjNKdE9pQjFjSEJsY21OaGMyVTdYQ0o5SWl3aU5DSTZJbnRjSW1sa1hDSTZOQ3hjSW5SNWNHVmNJanBjSW1OMWMzUnZiVndpTEZ3aVkyeGhjM05PWVcxbFhDSTZYQ0p0YzNBdFkyNHRNUzAwWENJc1hDSm1iMjUwUm1GdGFXeDVYQ0k2WENKTVlYUnZYQ0lzWENKbWIyNTBWMlZwWjJoMFhDSTZYQ0l4TURCY0lpeGNJbVp2Ym5SVGFYcGxYQ0k2T1RBc1hDSnNhVzVsU0dWcFoyaDBYQ0k2WENJNU1IQjRYQ0lzWENKamIyeHZjbHdpT2x3aUkyWm1abVptWmx3aUxGd2lZM1Z6ZEc5dFhDSTZYQ0owWlhoMExXRnNhV2R1T21ObGJuUmxjanRjSW4waUxDSTFJam9pZTF3aWFXUmNJam8xTEZ3aWRIbHdaVndpT2x3aVkzVnpkRzl0WENJc1hDSmpiR0Z6YzA1aGJXVmNJanBjSW0xemNDMWpiaTB4TFRWY0lpeGNJbVp2Ym5SR1lXMXBiSGxjSWpwY0lreGhkRzljSWl4Y0ltWnZiblJYWldsbmFIUmNJanBjSWprd01Gd2lMRndpWm05dWRGTnBlbVZjSWpveE1qQXNYQ0pzWlhSMFpYSlRjR0ZqYVc1blhDSTZOQ3hjSW14cGJtVklaV2xuYUhSY0lqcGNJbTV2Y20xaGJGd2lMRndpWTI5c2IzSmNJanBjSWlObVptWm1abVpjSWl4Y0ltTjFjM1J2YlZ3aU9sd2labTl1ZEMxM1pXbG5hSFE2SURnd01EdGNYRzUwWlhoMExYUnlZVzV6Wm05eWJUb2dkWEJ3WlhKallYTmxPMXdpZlNJc0lqY2lPaUo3WENKcFpGd2lPamNzWENKMGVYQmxYQ0k2WENKamRYTjBiMjFjSWl4Y0ltTnNZWE56VG1GdFpWd2lPbHdpYlhOd0xXTnVMVEV0TjF3aUxGd2labTl1ZEVaaGJXbHNlVndpT2x3aVRHRjBiMXdpTEZ3aVptOXVkRmRsYVdkb2RGd2lPbHdpTXpBd1hDSXNYQ0ptYjI1MFUybDZaVndpT2pNd0xGd2liR2x1WlVobGFXZG9kRndpT2x3aWJtOXliV0ZzWENJc1hDSmpiMnh2Y2x3aU9sd2lJMlptWm1abVpsd2lmU0lzSWpnaU9pSjdYQ0pwWkZ3aU9qZ3NYQ0ptYjI1MFYyVnBaMmgwWENJNlhDSnViM0p0WVd4Y0lpeGNJbXhwYm1WSVpXbG5hSFJjSWpwY0ltNXZjbTFoYkZ3aWZTSXNJamtpT2lKN1hDSnBaRndpT2prc1hDSjBlWEJsWENJNlhDSmpkWE4wYjIxY0lpeGNJbU5zWVhOelRtRnRaVndpT2x3aWJYTndMV051TFRFdE9Wd2lMRndpWm05dWRFWmhiV2xzZVZ3aU9sd2lUM0JsYmlCVFlXNXpYQ0lzWENKbWIyNTBWMlZwWjJoMFhDSTZYQ0p1YjNKdFlXeGNJaXhjSW1admJuUlRhWHBsWENJNk1qWXNYQ0pzYVc1bFNHVnBaMmgwWENJNlhDSnViM0p0WVd4Y0lpeGNJbU52Ykc5eVhDSTZYQ0lqWm1abVptWm1YQ0lzWENKamRYTjBiMjFjSWpwY0luUmxlSFF0WVd4cFoyNDZJR05sYm5SbGNqdGNJbjBpZlN3aVRWTlFZVzVsYkM1RlptWmxZM1FpT25zaU15STZJbnRjSW1sa1hDSTZNeXhjSW1aaFpHVmNJanAwY25WbExGd2lkSEpoYm5Oc1lYUmxXbHdpT2pVd01IMGlMQ0kwSWpvaWUxd2lhV1JjSWpvMExGd2labUZrWlZ3aU9uUnlkV1Y5SWl3aU55STZJbnRjSW1sa1hDSTZOeXhjSW1aaFpHVmNJanAwY25WbExGd2lkSEpoYm5Oc1lYUmxXbHdpT2pVd01IMGlMQ0k0SWpvaWUxd2lhV1JjSWpvNExGd2labUZrWlZ3aU9uUnlkV1Y5SWl3aU9TSTZJbnRjSW1sa1hDSTZPU3hjSW1aaFpHVmNJanAwY25WbExGd2lkSEpoYm5Oc1lYUmxXbHdpT2kwMU1EQjlJaXdpTVRBaU9pSjdYQ0pwWkZ3aU9qRXdMRndpWm1Ga1pWd2lPblJ5ZFdWOUlpd2lNVE1pT2lKN1hDSnBaRndpT2pFekxGd2labUZrWlZ3aU9uUnlkV1Y5SWl3aU1UUWlPaUo3WENKcFpGd2lPakUwTEZ3aVptRmtaVndpT25SeWRXVjlJaXdpTVRVaU9pSjdYQ0pwWkZ3aU9qRTFMRndpWm1Ga1pWd2lPblJ5ZFdWOUlpd2lNVFlpT2lKN1hDSnBaRndpT2pFMkxGd2labUZrWlZ3aU9uUnlkV1Y5SWl3aU1UY2lPaUo3WENKcFpGd2lPakUzTEZ3aVptRmtaVndpT25SeWRXVjlJaXdpTVRnaU9pSjdYQ0pwWkZ3aU9qRTRMRndpWm1Ga1pWd2lPblJ5ZFdWOUluMHNJazFUVUdGdVpXd3VUR0Y1WlhJaU9uc2lNaUk2SW50Y0ltbGtYQ0k2TWl4Y0ltNWhiV1ZjSWpwY0lteGhlV1Z5WENJc1hDSnBjMHh2WTJ0bFpGd2lPbVpoYkhObExGd2lhWE5JYVdSbFpGd2lPbVpoYkhObExGd2lhWE5UYjJ4dlpXUmNJanBtWVd4elpTeGNJbk5vYjNkVWNtRnVjMlp2Y20xY0lqcGNJbkJsY25Od1pXTjBhWFpsS0RJd01EQndlQ2tnZEhKaGJuTnNZWFJsV2lnMU1EQndlQ2xjSWl4Y0luTm9iM2RQY21sbmFXNWNJanBjSWpVd0pTQTFNQ1VnTUhCNFhDSXNYQ0p6YUc5M1JtRmtaVndpT25SeWRXVXNYQ0pvYVdSbFZISmhibk5tYjNKdFhDSTZYQ0pjSWl4Y0ltaHBaR1ZQY21sbmFXNWNJanBjSWx3aUxGd2lhR2xrWlVaaFpHVmNJanAwY25WbExGd2ljM1JoWjJWUFptWnpaWFJZWENJNk1DeGNJbk4wWVdkbFQyWm1jMlYwV1Z3aU9qQXNYQ0p2Y21SbGNsd2lPakFzWENKMGVYQmxYQ0k2WENKMFpYaDBYQ0lzWENKd2IzTnBkR2x2Ymx3aU9sd2libTl5YldGc1hDSXNYQ0p1YjFOM2FYQmxYQ0k2Wm1Gc2MyVXNYQ0pqYjI1MFpXNTBYQ0k2WENKVVQxUkJUQzVEVWtWQlZFbFdSVndpTEZ3aWRtbGtaVzljSWpwY0ltaDBkSEE2THk5d2JHRjVaWEl1ZG1sdFpXOHVZMjl0TDNacFpHVnZMekV4TnpJeE1qUXlYQ0lzWENKaGJHbG5ibHdpT2x3aWRHOXdYQ0lzWENKMWMyVkJZM1JwYjI1Y0lqcG1ZV3h6WlN4Y0luTmpjbTlzYkVSMWNtRjBhVzl1WENJNk1peGNJbTltWm5ObGRGaGNJam93TEZ3aWIyWm1jMlYwV1Z3aU9qY3NYQ0p5WlhOcGVtVmNJanAwY25WbExGd2labWw0WldSY0lqcG1ZV3h6WlN4Y0luZHBaSFJvYkdsdGFYUmNJanBjSWpCY0lpeGNJbTl5YVdkcGJsd2lPbHdpYldOY0lpeGNJbk4wWVhsSWIzWmxjbHdpT25SeWRXVXNYQ0pqYkdGemMwNWhiV1ZjSWpwY0ltMXpjQzFqYmkweExUSmNJaXhjSW5Ob2IzZEVkWEpoZEdsdmJsd2lPakF1TXpnM05TeGNJbk5vYjNkRVpXeGhlVndpT2pBc1hDSnphRzkzUldGelpWd2lPbHdpWldGelpVOTFkRkYxYVc1MFhDSXNYQ0p6YUc5M1JXWm1SblZ1WTF3aU9sd2lkQ2gwY25WbExHNHNiaXcxTURBc2JpeHVMRzRzYml4dUxHNHNiaXh1TEc0c2JpeHVLVndpTEZ3aWRYTmxTR2xrWlZ3aU9tWmhiSE5sTEZ3aWFHbGtaVVIxY21GMGFXOXVYQ0k2TVN4Y0ltaHBaR1ZFWld4aGVWd2lPakVzWENKb2FXUmxSV0Z6WlZ3aU9sd2laV0Z6WlU5MWRGRjFhVzUwWENJc1hDSmlkRzVEYkdGemMxd2lPbHdpYlhNdFluUnVJRzF6TFdSbFptRjFiSFF0WW5SdVhDSXNYQ0p6Ykdsa1pWd2lPbHdpTVZ3aUxGd2ljM1I1YkdWTmIyUmxiRndpT2pJc1hDSnphRzkzUldabVpXTjBYQ0k2TXl4Y0ltaHBaR1ZGWm1abFkzUmNJam8wZlNJc0lqUWlPaUo3WENKcFpGd2lPalFzWENKdVlXMWxYQ0k2WENKc1lYbGxjbHdpTEZ3aWFYTk1iMk5yWldSY0lqcG1ZV3h6WlN4Y0ltbHpTR2xrWldSY0lqcG1ZV3h6WlN4Y0ltbHpVMjlzYjJWa1hDSTZabUZzYzJVc1hDSnphRzkzVkhKaGJuTm1iM0p0WENJNlhDSndaWEp6Y0dWamRHbDJaU2d5TURBd2NIZ3BJSFJ5WVc1emJHRjBaVm9vTlRBd2NIZ3BYQ0lzWENKemFHOTNUM0pwWjJsdVhDSTZYQ0kxTUNVZ05UQWxJREJ3ZUZ3aUxGd2ljMmh2ZDBaaFpHVmNJanAwY25WbExGd2lhR2xrWlZSeVlXNXpabTl5YlZ3aU9sd2lYQ0lzWENKb2FXUmxUM0pwWjJsdVhDSTZYQ0pjSWl4Y0ltaHBaR1ZHWVdSbFhDSTZkSEoxWlN4Y0luTjBZV2RsVDJabWMyVjBXRndpT2pBc1hDSnpkR0ZuWlU5bVpuTmxkRmxjSWpvd0xGd2liM0prWlhKY0lqb3hMRndpZEhsd1pWd2lPbHdpZEdWNGRGd2lMRndpY0c5emFYUnBiMjVjSWpwY0ltNXZjbTFoYkZ3aUxGd2libTlUZDJsd1pWd2lPbVpoYkhObExGd2lZMjl1ZEdWdWRGd2lPbHdpUVVkRlRrTlpYQ0lzWENKMmFXUmxiMXdpT2x3aWFIUjBjRG92TDNCc1lYbGxjaTUyYVcxbGJ5NWpiMjB2ZG1sa1pXOHZNVEUzTWpFeU5ESmNJaXhjSW1Gc2FXZHVYQ0k2WENKMGIzQmNJaXhjSW5WelpVRmpkR2x2Ymx3aU9tWmhiSE5sTEZ3aWMyTnliMnhzUkhWeVlYUnBiMjVjSWpveUxGd2liMlptYzJWMFdGd2lPakFzWENKdlptWnpaWFJaWENJNk5EQXNYQ0p5WlhOcGVtVmNJanAwY25WbExGd2labWw0WldSY0lqcG1ZV3h6WlN4Y0luZHBaSFJvYkdsdGFYUmNJanBjSWpCY0lpeGNJbTl5YVdkcGJsd2lPbHdpYldOY0lpeGNJbk4wWVhsSWIzWmxjbHdpT25SeWRXVXNYQ0pqYkdGemMwNWhiV1ZjSWpwY0ltMXpjQzFqYmkweExUUmNJaXhjSW5Ob2IzZEVkWEpoZEdsdmJsd2lPakF1TXpnM05TeGNJbk5vYjNkRVpXeGhlVndpT2pBdU5ESTFMRndpYzJodmQwVmhjMlZjSWpwY0ltVmhjMlZQZFhSUmRXbHVkRndpTEZ3aWMyaHZkMFZtWmtaMWJtTmNJanBjSW5Rb2RISjFaU3h1TEc0c05UQXdMRzRzYml4dUxHNHNiaXh1TEc0c2JpeHVMRzRzYmlsY0lpeGNJblZ6WlVocFpHVmNJanBtWVd4elpTeGNJbWhwWkdWRWRYSmhkR2x2Ymx3aU9qRXNYQ0pvYVdSbFJHVnNZWGxjSWpveExGd2lhR2xrWlVWaGMyVmNJanBjSW1WaGMyVlBkWFJSZFdsdWRGd2lMRndpWW5SdVEyeGhjM05jSWpwY0ltMXpMV0owYmlCdGN5MWtaV1poZFd4MExXSjBibHdpTEZ3aWMyeHBaR1ZjSWpwdWRXeHNMRndpYzNSNWJHVk5iMlJsYkZ3aU9qUXNYQ0p6YUc5M1JXWm1aV04wWENJNk55eGNJbWhwWkdWRlptWmxZM1JjSWpvNGZTSXNJalVpT2lKN1hDSnBaRndpT2pVc1hDSnVZVzFsWENJNlhDSnNZWGxsY2x3aUxGd2lhWE5NYjJOclpXUmNJanBtWVd4elpTeGNJbWx6U0dsa1pXUmNJanBtWVd4elpTeGNJbWx6VTI5c2IyVmtYQ0k2Wm1Gc2MyVXNYQ0p6YUc5M1ZISmhibk5tYjNKdFhDSTZYQ0p3WlhKemNHVmpkR2wyWlNneU1EQXdjSGdwSUhSeVlXNXpiR0YwWlZvb0xUVXdNSEI0S1Z3aUxGd2ljMmh2ZDA5eWFXZHBibHdpT2x3aU5UQWxJRFV3SlNBd2NIaGNJaXhjSW5Ob2IzZEdZV1JsWENJNmRISjFaU3hjSW1ocFpHVlVjbUZ1YzJadmNtMWNJanBjSWx3aUxGd2lhR2xrWlU5eWFXZHBibHdpT2x3aVhDSXNYQ0pvYVdSbFJtRmtaVndpT25SeWRXVXNYQ0p6ZEdGblpVOW1abk5sZEZoY0lqb3dMRndpYzNSaFoyVlBabVp6WlhSWlhDSTZNQ3hjSW05eVpHVnlYQ0k2TUN4Y0luUjVjR1ZjSWpwY0luUmxlSFJjSWl4Y0luQnZjMmwwYVc5dVhDSTZYQ0p1YjNKdFlXeGNJaXhjSW01dlUzZHBjR1ZjSWpwbVlXeHpaU3hjSW1OdmJuUmxiblJjSWpwY0lrTlNSVUZVU1ZaRlhDSXNYQ0oyYVdSbGIxd2lPbHdpYUhSMGNEb3ZMM0JzWVhsbGNpNTJhVzFsYnk1amIyMHZkbWxrWlc4dk1URTNNakV5TkRKY0lpeGNJbUZzYVdkdVhDSTZYQ0owYjNCY0lpeGNJblZ6WlVGamRHbHZibHdpT21aaGJITmxMRndpYzJOeWIyeHNSSFZ5WVhScGIyNWNJam95TEZ3aWIyWm1jMlYwV0Z3aU9qQXNYQ0p2Wm1aelpYUlpYQ0k2TFRVMkxGd2ljbVZ6YVhwbFhDSTZkSEoxWlN4Y0ltWnBlR1ZrWENJNlptRnNjMlVzWENKM2FXUjBhR3hwYldsMFhDSTZYQ0l3WENJc1hDSnZjbWxuYVc1Y0lqcGNJbTFqWENJc1hDSnpkR0Y1U0c5MlpYSmNJanAwY25WbExGd2lZMnhoYzNOT1lXMWxYQ0k2WENKdGMzQXRZMjR0TVMwMVhDSXNYQ0p6YUc5M1JIVnlZWFJwYjI1Y0lqb3dMak00TnpVc1hDSnphRzkzUkdWc1lYbGNJam93TEZ3aWMyaHZkMFZoYzJWY0lqcGNJbVZoYzJWUGRYUlJkV2x1ZEZ3aUxGd2ljMmh2ZDBWbVprWjFibU5jSWpwY0luUW9kSEoxWlN4dUxHNHNMVFV3TUN4dUxHNHNiaXh1TEc0c2JpeHVMRzRzYml4dUxHNHBYQ0lzWENKMWMyVklhV1JsWENJNlptRnNjMlVzWENKb2FXUmxSSFZ5WVhScGIyNWNJam94TEZ3aWFHbGtaVVJsYkdGNVhDSTZNU3hjSW1ocFpHVkZZWE5sWENJNlhDSmxZWE5sVDNWMFVYVnBiblJjSWl4Y0ltSjBia05zWVhOelhDSTZYQ0p0Y3kxaWRHNGdiWE10WkdWbVlYVnNkQzFpZEc1Y0lpeGNJbk5zYVdSbFhDSTZiblZzYkN4Y0luTjBlV3hsVFc5a1pXeGNJam8xTEZ3aWMyaHZkMFZtWm1WamRGd2lPamtzWENKb2FXUmxSV1ptWldOMFhDSTZNVEI5SWl3aU55STZJbnRjSW1sa1hDSTZOeXhjSW01aGJXVmNJanBjSW14aGVXVnlYQ0lzWENKcGMweHZZMnRsWkZ3aU9tWmhiSE5sTEZ3aWFYTklhV1JsWkZ3aU9tWmhiSE5sTEZ3aWFYTlRiMnh2WldSY0lqcG1ZV3h6WlN4Y0luTm9iM2RVY21GdWMyWnZjbTFjSWpwY0lsd2lMRndpYzJodmQwOXlhV2RwYmx3aU9sd2lYQ0lzWENKemFHOTNSbUZrWlZ3aU9uUnlkV1VzWENKb2FXUmxWSEpoYm5ObWIzSnRYQ0k2WENKY0lpeGNJbWhwWkdWUGNtbG5hVzVjSWpwY0lsd2lMRndpYUdsa1pVWmhaR1ZjSWpwMGNuVmxMRndpYzNSaFoyVlBabVp6WlhSWVhDSTZNQ3hjSW5OMFlXZGxUMlptYzJWMFdWd2lPakFzWENKdmNtUmxjbHdpT2pNc1hDSjBlWEJsWENJNlhDSjBaWGgwWENJc1hDSndiM05wZEdsdmJsd2lPbHdpYm05eWJXRnNYQ0lzWENKdWIxTjNhWEJsWENJNlptRnNjMlVzWENKamIyNTBaVzUwWENJNlhDSkNlU0JVYjNSaGJDQkNkWE5wYm1WemMxd2lMRndpZG1sa1pXOWNJanBjSW1oMGRIQTZMeTl3YkdGNVpYSXVkbWx0Wlc4dVkyOXRMM1pwWkdWdkx6RXhOekl4TWpReVhDSXNYQ0poYkdsbmJsd2lPbHdpZEc5d1hDSXNYQ0oxYzJWQlkzUnBiMjVjSWpwbVlXeHpaU3hjSW5OamNtOXNiRVIxY21GMGFXOXVYQ0k2TWl4Y0ltOW1abk5sZEZoY0lqb3dMRndpYjJabWMyVjBXVndpT2pFM01TeGNJbkpsYzJsNlpWd2lPblJ5ZFdVc1hDSm1hWGhsWkZ3aU9tWmhiSE5sTEZ3aWQybGtkR2hzYVcxcGRGd2lPbHdpTUZ3aUxGd2liM0pwWjJsdVhDSTZYQ0p0WTF3aUxGd2ljM1JoZVVodmRtVnlYQ0k2ZEhKMVpTeGNJbU5zWVhOelRtRnRaVndpT2x3aWJYTndMV051TFRFdE4xd2lMRndpYzJodmQwUjFjbUYwYVc5dVhDSTZNQzQwTlN4Y0luTm9iM2RFWld4aGVWd2lPakV1TXpZeU5TeGNJbk5vYjNkRllYTmxYQ0k2WENKbFlYTmxUM1YwVVhWcGJuUmNJaXhjSW5WelpVaHBaR1ZjSWpwbVlXeHpaU3hjSW1ocFpHVkVkWEpoZEdsdmJsd2lPakVzWENKb2FXUmxSR1ZzWVhsY0lqb3hMRndpYUdsa1pVVmhjMlZjSWpwY0ltVmhjMlZQZFhSUmRXbHVkRndpTEZ3aVluUnVRMnhoYzNOY0lqcGNJbTF6TFdKMGJpQnRjeTFrWldaaGRXeDBMV0owYmx3aUxGd2ljMnhwWkdWY0lqb3pMRndpYzNSNWJHVk5iMlJsYkZ3aU9qY3NYQ0p6YUc5M1JXWm1aV04wWENJNk1UTXNYQ0pvYVdSbFJXWm1aV04wWENJNk1UUjlJaXdpT0NJNkludGNJbWxrWENJNk9DeGNJbTVoYldWY0lqcGNJbXhoZVdWeVhDSXNYQ0pwYzB4dlkydGxaRndpT21aaGJITmxMRndpYVhOSWFXUmxaRndpT21aaGJITmxMRndpYVhOVGIyeHZaV1JjSWpwbVlXeHpaU3hjSW5Ob2IzZFVjbUZ1YzJadmNtMWNJanBjSWx3aUxGd2ljMmh2ZDA5eWFXZHBibHdpT2x3aVhDSXNYQ0p6YUc5M1JtRmtaVndpT25SeWRXVXNYQ0pvYVdSbFZISmhibk5tYjNKdFhDSTZYQ0pjSWl4Y0ltaHBaR1ZQY21sbmFXNWNJanBjSWx3aUxGd2lhR2xrWlVaaFpHVmNJanAwY25WbExGd2lhVzFuVkdoMWJXSmNJanBjSWk4eU1ERTFMekE1TDNOc2FXUmxjaTB4TFdScGRtbGtaWEl1YW5CblhDSXNYQ0p6ZEdGblpVOW1abk5sZEZoY0lqb3dMRndpYzNSaFoyVlBabVp6WlhSWlhDSTZNQ3hjSW05eVpHVnlYQ0k2TWl4Y0luUjVjR1ZjSWpwY0ltbHRZV2RsWENJc1hDSndiM05wZEdsdmJsd2lPbHdpYm05eWJXRnNYQ0lzWENKdWIxTjNhWEJsWENJNlptRnNjMlVzWENKamIyNTBaVzUwWENJNlhDSk1iM0psYlNCSmNITjFiVndpTEZ3aWFXMW5YQ0k2WENJdk1qQXhOUzh3T1M5emJHbGtaWEl0TVMxa2FYWnBaR1Z5TG1wd1oxd2lMRndpZG1sa1pXOWNJanBjSW1oMGRIQTZMeTl3YkdGNVpYSXVkbWx0Wlc4dVkyOXRMM1pwWkdWdkx6RXhOekl4TWpReVhDSXNYQ0poYkdsbmJsd2lPbHdpZEc5d1hDSXNYQ0oxYzJWQlkzUnBiMjVjSWpwbVlXeHpaU3hjSW5OamNtOXNiRVIxY21GMGFXOXVYQ0k2TWl4Y0ltOW1abk5sZEZoY0lqb3dMRndpYjJabWMyVjBXVndpT2pFeU1TeGNJbkpsYzJsNlpWd2lPblJ5ZFdVc1hDSm1hWGhsWkZ3aU9tWmhiSE5sTEZ3aWQybGtkR2hzYVcxcGRGd2lPbHdpTUZ3aUxGd2liM0pwWjJsdVhDSTZYQ0p0WTF3aUxGd2ljM1JoZVVodmRtVnlYQ0k2ZEhKMVpTeGNJbk5vYjNkRWRYSmhkR2x2Ymx3aU9qQXVORE0zTlN4Y0luTm9iM2RFWld4aGVWd2lPakF1T1RFeU5TeGNJbk5vYjNkRllYTmxYQ0k2WENKbFlYTmxUM1YwVVhWcGJuUmNJaXhjSW5WelpVaHBaR1ZjSWpwbVlXeHpaU3hjSW1ocFpHVkVkWEpoZEdsdmJsd2lPakVzWENKb2FXUmxSR1ZzWVhsY0lqb3hMRndpYUdsa1pVVmhjMlZjSWpwY0ltVmhjMlZQZFhSUmRXbHVkRndpTEZ3aVluUnVRMnhoYzNOY0lqcGNJbTF6TFdKMGJpQnRjeTFrWldaaGRXeDBMV0owYmx3aUxGd2ljMnhwWkdWY0lqb3pMRndpYzNSNWJHVk5iMlJsYkZ3aU9qZ3NYQ0p6YUc5M1JXWm1aV04wWENJNk1UVXNYQ0pvYVdSbFJXWm1aV04wWENJNk1UWjlJaXdpT1NJNkludGNJbWxrWENJNk9TeGNJbTVoYldWY0lqcGNJbXhoZVdWeVhDSXNYQ0pwYzB4dlkydGxaRndpT21aaGJITmxMRndpYVhOSWFXUmxaRndpT21aaGJITmxMRndpYVhOVGIyeHZaV1JjSWpwbVlXeHpaU3hjSW5Ob2IzZFVjbUZ1YzJadmNtMWNJanBjSWx3aUxGd2ljMmh2ZDA5eWFXZHBibHdpT2x3aVhDSXNYQ0p6YUc5M1JtRmtaVndpT25SeWRXVXNYQ0pvYVdSbFZISmhibk5tYjNKdFhDSTZYQ0pjSWl4Y0ltaHBaR1ZQY21sbmFXNWNJanBjSWx3aUxGd2lhR2xrWlVaaFpHVmNJanAwY25WbExGd2ljM1JoWjJWUFptWnpaWFJZWENJNk1DeGNJbk4wWVdkbFQyWm1jMlYwV1Z3aU9qQXNYQ0p2Y21SbGNsd2lPakVzWENKMGVYQmxYQ0k2WENKMFpYaDBYQ0lzWENKd2IzTnBkR2x2Ymx3aU9sd2libTl5YldGc1hDSXNYQ0p1YjFOM2FYQmxYQ0k2Wm1Gc2MyVXNYQ0pqYjI1MFpXNTBYQ0k2WENKWFpTQmhjbVVnWVNCemNIVmxjaUJqYjI5c0lHTnlaV0YwYVhabElHRm5aVzVqZVN3Z1RHOXVaRzl1SUdKaGMyVmtMaUJYWlNCb1lYWmxJRzF2Y21VZ2RHaGhiaUF4TUNCNVpXRnljeUJ2WmlCbGVIQmxjbWxsYm1ObGN5NWNJaXhjSW5acFpHVnZYQ0k2WENKb2RIUndPaTh2Y0d4aGVXVnlMblpwYldWdkxtTnZiUzkyYVdSbGJ5OHhNVGN5TVRJME1sd2lMRndpWVd4cFoyNWNJanBjSW5SdmNGd2lMRndpZFhObFFXTjBhVzl1WENJNlptRnNjMlVzWENKelkzSnZiR3hFZFhKaGRHbHZibHdpT2pJc1hDSnZabVp6WlhSWVhDSTZNQ3hjSW05bVpuTmxkRmxjSWpveE1Ua3NYQ0ozYVdSMGFGd2lPamN3TUN4Y0luSmxjMmw2WlZ3aU9uUnlkV1VzWENKbWFYaGxaRndpT21aaGJITmxMRndpZDJsa2RHaHNhVzFwZEZ3aU9sd2lNRndpTEZ3aWIzSnBaMmx1WENJNlhDSnRZMXdpTEZ3aWMzUmhlVWh2ZG1WeVhDSTZkSEoxWlN4Y0ltTnNZWE56VG1GdFpWd2lPbHdpYlhOd0xXTnVMVEV0T1Z3aUxGd2ljMmh2ZDBSMWNtRjBhVzl1WENJNk1DNDBOelVzWENKemFHOTNSR1ZzWVhsY0lqb3dMalF4TWpVc1hDSnphRzkzUldGelpWd2lPbHdpWldGelpVOTFkRkYxYVc1MFhDSXNYQ0oxYzJWSWFXUmxYQ0k2Wm1Gc2MyVXNYQ0pvYVdSbFJIVnlZWFJwYjI1Y0lqb3hMRndpYUdsa1pVUmxiR0Y1WENJNk1TeGNJbWhwWkdWRllYTmxYQ0k2WENKbFlYTmxUM1YwVVhWcGJuUmNJaXhjSW1KMGJrTnNZWE56WENJNlhDSnRjeTFpZEc0Z2JYTXRaR1ZtWVhWc2RDMWlkRzVjSWl4Y0luTnNhV1JsWENJNlhDSXhYQ0lzWENKemRIbHNaVTF2WkdWc1hDSTZPU3hjSW5Ob2IzZEZabVpsWTNSY0lqb3hOeXhjSW1ocFpHVkZabVpsWTNSY0lqb3hPSDBpZlgwPSIsInR5cGUiOiJjdXN0b20iLCJzbGlkZXNfbnVtIjoiMiJ9fSwib3JpZ2luX3VwbG9hZHNfdXJsIjoiaHR0cDpcL1wvZGVtby5nb29kbGF5ZXJzLmNvbVwvdG90YWxidXNpbmVzc1wvY3JlYXRpdmUwM1wvd3AtY29udGVudFwvdXBsb2FkcyIsInByZXNldF9zdHlsZXMiOiJleUp0WlhSaElqcDdmWDA9IiwicHJlc2V0X2VmZmVjdHMiOiIifQ==',
					'screenshot'=> get_template_directory_uri() . '/images/sample-slider.png',
					'selected' => false
				),
				array(
					'label'     => esc_html__( 'Sample Slider Plastic', 'totalbusiness' ),
					'id'        => 'totalbusiness-sample-slider6',
					'slidertype'=> 'custom',
					'importdata'=> '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',
					'screenshot'=> get_template_directory_uri() . '/images/sample-slider.png',
					'selected' => false
				),
				array(
					'label'     => esc_html__( 'Sample Slider Steel', 'totalbusiness' ),
					'id'        => 'totalbusiness-sample-slider7',
					'slidertype'=> 'custom',
					'importdata'=> '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',
					'screenshot'=> get_template_directory_uri() . '/images/sample-slider.png',
					'selected' => false
				),
				array(
					'label'     => esc_html__( 'Sample Slider Wedding', 'totalbusiness' ),
					'id'        => 'totalbusiness-sample-slider8',
					'slidertype'=> 'custom',
					'importdata'=> 'eyJzbGlkZXJzX2RhdGEiOnsiMSI6eyJ0aXRsZSI6IkhvbWVwYWdlIC0gV2VkZGluZyIsInBhcmFtcyI6ImV5SnRaWFJoSWpwN0lsTmxkSFJwYm1keklXbGtjeUk2SWpFaUxDSlRaWFIwYVc1bmN5RnVaWGgwU1dRaU9qSXNJbE5zYVdSbElXbGtjeUk2SWpFc015SXNJbE5zYVdSbElXNWxlSFJKWkNJNk5Dd2lRMjl1ZEhKdmJDRnBaSE1pT2lJeExESWlMQ0pEYjI1MGNtOXNJVzVsZUhSSlpDSTZNeXdpVTNSNWJHVWhhV1J6SWpvaU1Td3lMRFFzTlN3M0xEZ2lMQ0pUZEhsc1pTRnVaWGgwU1dRaU9qa3NJa1ZtWm1WamRDRnBaSE1pT2lJeExESXNNeXcwTERjc09DdzVMREV3TERFekxERTBMREUxTERFMklpd2lSV1ptWldOMElXNWxlSFJKWkNJNk1UY3NJa3hoZVdWeUlXbGtjeUk2SWpFc01pdzBMRFVzTnl3NElpd2lUR0Y1WlhJaGJtVjRkRWxrSWpvNWZTd2lUVk5RWVc1bGJDNVRaWFIwYVc1bmN5STZleUl4SWpvaWUxd2lhV1JjSWpwY0lqRmNJaXhjSW5OdVlYQndhVzVuWENJNlptRnNjMlVzWENKdVlXMWxYQ0k2WENKSWIyMWxjR0ZuWlNBdElGZGxaR1JwYm1kY0lpeGNJbmRwWkhSb1hDSTZNVEUwTUN4Y0ltaGxhV2RvZEZ3aU9qWXpNQ3hjSW5keVlYQndaWEpYYVdSMGFGVnVhWFJjSWpwY0luQjRYQ0lzWENKaGRYUnZRM0p2Y0Z3aU9tWmhiSE5sTEZ3aWRIbHdaVndpT2x3aVkzVnpkRzl0WENJc1hDSnpiR2xrWlhKSlpGd2lPbHdpTVZ3aUxGd2liR0Y1YjNWMFhDSTZYQ0ptZFd4c2QybGtkR2hjSWl4Y0ltRjFkRzlJWldsbmFIUmNJanBtWVd4elpTeGNJblJ5Vm1sbGQxd2lPbHdpWW1GemFXTmNJaXhjSW5Od1pXVmtYQ0k2WENJeU1Gd2lMRndpYzNCaFkyVmNJanBjSWpCY0lpeGNJbk4wWVhKMFhDSTZYQ0l4WENJc1hDSm5jbUZpUTNWeWMyOXlYQ0k2WENJeFhDSXNYQ0p6ZDJsd1pWd2lPbVpoYkhObExGd2liVzkxYzJWY0lqcG1ZV3h6WlN4Y0luZG9aV1ZzWENJNlhDSmNJaXhjSW10bGVXSnZZWEprWENJNmRISjFaU3hjSW1GMWRHOXdiR0Y1WENJNmRISjFaU3hjSW14dmIzQmNJanAwY25WbExGd2ljMmgxWm1ac1pWd2lPbHdpWENJc1hDSndjbVZzYjJGa1hDSTZYQ0l0TVZ3aUxGd2liM1psY2xCaGRYTmxYQ0k2WENJeFhDSXNYQ0psYm1SUVlYVnpaVndpT2x3aVhDSXNYQ0pvYVdSbFRHRjVaWEp6WENJNlhDSmNJaXhjSW1ScGNsd2lPbHdpYUZ3aUxGd2ljR0Z5WVd4c1lYaE5iMlJsWENJNlhDSnZabVpjSWl4Y0luVnpaVVJsWlhCTWFXNXJYQ0k2Wm1Gc2MyVXNYQ0prWldWd1RHbHVhMXdpT2x3aWJYTXRNVEZjSWl4Y0ltUmxaWEJNYVc1clZIbHdaVndpT2x3aWNHRjBhRndpTEZ3aWMyTnliMnhzVUdGeVlXeHNZWGhOYjNabFhDSTZNekFzWENKelkzSnZiR3hRWVhKaGJHeGhlRUpIVFc5MlpWd2lPalV3TEZ3aWMyTnliMnhzVUdGeVlXeHNZWGhHWVdSbFhDSTZkSEoxWlN4Y0ltTmxiblJsY2tOdmJuUnliMnh6WENJNlhDSXhYQ0lzWENKcGJuTjBZVzUwVTJodmQweGhlV1Z5YzF3aU9sd2lYQ0lzWENKamJHRnpjMDVoYldWY0lqcGNJbHdpTEZ3aVltZERiMnh2Y2x3aU9sd2lJek0xTXpVek5Wd2lMRndpYzJ0cGJsd2lPbHdpYlhNdGMydHBiaTFrWldaaGRXeDBYQ0lzWENKdGMxUmxiWEJzWVhSbFhDSTZYQ0pqZFhOMGIyMWNJaXhjSW0xelZHVnRjR3hoZEdWRGJHRnpjMXdpT2x3aVhDSXNYQ0oxYzJWa1JtOXVkSE5jSWpwY0lreGhkRzg2T1RBd0xERXdNQ3d6TURCY0luMGlmU3dpVFZOUVlXNWxiQzVUYkdsa1pTSTZleUl4SWpvaWUxd2lhV1JjSWpwY0lqRmNJaXhjSW5ScGJXVnNhVzVsWDJoY0lqb3lNREFzWENKaVoxUm9kVzFpWENJNlhDSXZNakF4TlM4d09TOXpiR2xrWlhJdE1qUXRNVFV3ZURFMU1DNXFjR2RjSWl4Y0ltOXlaR1Z5WENJNk1TeGNJbUpuWENJNlhDSXZNakF4TlM4d09TOXpiR2xrWlhJdE1qUXVhbkJuWENJc1hDSmtkWEpoZEdsdmJsd2lPamNzWENKbWFXeHNUVzlrWlZ3aU9sd2labWxzYkZ3aUxGd2lZbWQyWDJacGJHeHRiMlJsWENJNlhDSm1hV3hzWENJc1hDSmlaM1pmYkc5dmNGd2lPbHdpTVZ3aUxGd2lZbWQyWDIxMWRHVmNJanBjSWpGY0lpeGNJbUpuZGw5aGRYUnZjR0YxYzJWY0lqcGNJbHdpTEZ3aVltZEJiSFJjSWpwY0lsd2lMRndpYkdGNVpYSmZhV1J6WENJNlcxd2lNVndpTERKZGZTSXNJak1pT2lKN1hDSnBaRndpT2pNc1hDSjBhVzFsYkdsdVpWOW9YQ0k2TWpBd0xGd2lZbWRVYUhWdFlsd2lPbHdpTHpJd01UVXZNRGt2YzJ4cFpHVnlMVEUwTFRFMU1IZ3hOVEF1YW5CblhDSXNYQ0p2Y21SbGNsd2lPakFzWENKaVoxd2lPbHdpTHpJd01UVXZNRGt2YzJ4cFpHVnlMVEUwTG1wd1oxd2lMRndpWkhWeVlYUnBiMjVjSWpvM0xGd2labWxzYkUxdlpHVmNJanBjSW1acGJHeGNJaXhjSW1KbmRsOW1hV3hzYlc5a1pWd2lPbHdpWm1sc2JGd2lMRndpWW1kMlgyeHZiM0JjSWpwY0lqRmNJaXhjSW1KbmRsOXRkWFJsWENJNlhDSXhYQ0lzWENKaVozWmZZWFYwYjNCaGRYTmxYQ0k2WENKY0lpeGNJbUpuUVd4MFhDSTZYQ0pjSWl4Y0lteGhlV1Z5WDJsa2Mxd2lPbHMwTERVc055dzRYWDBpZlN3aVRWTlFZVzVsYkM1RGIyNTBjbTlzSWpwN0lqRWlPaUo3WENKcFpGd2lPbHdpTVZ3aUxGd2liR0ZpWld4Y0lqcGNJa0Z5Y205M2Mxd2lMRndpYm1GdFpWd2lPbHdpWVhKeWIzZHpYQ0lzWENKaGRYUnZTR2xrWlZ3aU9uUnlkV1VzWENKdmRtVnlWbWxrWlc5Y0lqcDBjblZsTEZ3aWFXNXpaWFJjSWpwMGNuVmxmU0lzSWpJaU9pSjdYQ0pwWkZ3aU9qSXNYQ0pzWVdKbGJGd2lPbHdpUW5Wc2JHVjBjMXdpTEZ3aWJtRnRaVndpT2x3aVluVnNiR1YwYzF3aUxGd2lZWFYwYjBocFpHVmNJanBtWVd4elpTeGNJbTkyWlhKV2FXUmxiMXdpT25SeWRXVXNYQ0p0WVhKbmFXNWNJam94TlN4Y0ltUnBjbHdpT2x3aWFGd2lMRndpYzNCaFkyVmNJam8yTEZ3aVlXeHBaMjVjSWpwY0ltSnZkSFJ2YlZ3aUxGd2lhVzV6WlhSY0lqcDBjblZsZlNKOUxDSk5VMUJoYm1Wc0xsTjBlV3hsSWpwN0lqRWlPaUo3WENKcFpGd2lPbHdpTVZ3aUxGd2lkSGx3WlZ3aU9sd2lZM1Z6ZEc5dFhDSXNYQ0pqYkdGemMwNWhiV1ZjSWpwY0ltMXpjQzFqYmkweExURmNJaXhjSW5CaFpHUnBibWRVYjNCY0lqb3hOU3hjSW5CaFpHUnBibWRTYVdkb2RGd2lPak0xTEZ3aWNHRmtaR2x1WjBKdmRIUnZiVndpT2pFMUxGd2ljR0ZrWkdsdVoweGxablJjSWpvek5TeGNJbUp2Y21SbGNsUnZjRndpT2pJc1hDSmliM0prWlhKU2FXZG9kRndpT2pJc1hDSmliM0prWlhKQ2IzUjBiMjFjSWpveUxGd2lZbTl5WkdWeVRHVm1kRndpT2pJc1hDSmliM0prWlhKVGRIbHNaVndpT2x3aWMyOXNhV1JjSWl4Y0ltWnZiblJYWldsbmFIUmNJanBjSW01dmNtMWhiRndpTEZ3aVptOXVkRk5wZW1WY0lqbzBPQ3hjSW14cGJtVklaV2xuYUhSY0lqcGNJbTV2Y20xaGJGd2lMRndpWTI5c2IzSmNJanBjSWlObVptWm1abVpjSWl4Y0ltTjFjM1J2YlZ3aU9sd2labTl1ZEMxM1pXbG5hSFE2SURJd01EczlYQ0o5SWl3aU1pSTZJbnRjSW1sa1hDSTZNaXhjSW5SNWNHVmNJanBjSW1OMWMzUnZiVndpTEZ3aVkyeGhjM05PWVcxbFhDSTZYQ0p0YzNBdFkyNHRNUzB5WENJc1hDSm1iMjUwUm1GdGFXeDVYQ0k2WENKTVlYUnZYQ0lzWENKbWIyNTBWMlZwWjJoMFhDSTZYQ0k1TURCY0lpeGNJbVp2Ym5SVGFYcGxYQ0k2T0RVc1hDSnNaWFIwWlhKVGNHRmphVzVuWENJNk1peGNJbXhwYm1WSVpXbG5hSFJjSWpwY0ltNXZjbTFoYkZ3aUxGd2lZMjlzYjNKY0lqcGNJaU5tWm1abVptWmNJaXhjSW1OMWMzUnZiVndpT2x3aVptOXVkQzEzWldsbmFIUTZJRGd3TUR0Y1hHNTBaWGgwTFhSeVlXNXpabTl5YlRvZ2RYQndaWEpqWVhObE8xd2lmU0lzSWpRaU9pSjdYQ0pwWkZ3aU9qUXNYQ0owZVhCbFhDSTZYQ0pqZFhOMGIyMWNJaXhjSW1Oc1lYTnpUbUZ0WlZ3aU9sd2liWE53TFdOdUxURXRORndpTEZ3aVptOXVkRVpoYldsc2VWd2lPbHdpVEdGMGIxd2lMRndpWm05dWRGZGxhV2RvZEZ3aU9sd2lNVEF3WENJc1hDSm1iMjUwVTJsNlpWd2lPamt3TEZ3aWJHbHVaVWhsYVdkb2RGd2lPbHdpT1RCd2VGd2lMRndpWTI5c2IzSmNJanBjSWlObVptWm1abVpjSWl4Y0ltTjFjM1J2YlZ3aU9sd2lkR1Y0ZEMxaGJHbG5ianBqWlc1MFpYSTdYQ0o5SWl3aU5TSTZJbnRjSW1sa1hDSTZOU3hjSW5SNWNHVmNJanBjSW1OMWMzUnZiVndpTEZ3aVkyeGhjM05PWVcxbFhDSTZYQ0p0YzNBdFkyNHRNUzAxWENJc1hDSm1iMjUwUm1GdGFXeDVYQ0k2WENKTVlYUnZYQ0lzWENKbWIyNTBWMlZwWjJoMFhDSTZYQ0k1TURCY0lpeGNJbVp2Ym5SVGFYcGxYQ0k2TVRJd0xGd2liR1YwZEdWeVUzQmhZMmx1WjF3aU9qUXNYQ0pzYVc1bFNHVnBaMmgwWENJNlhDSnViM0p0WVd4Y0lpeGNJbU52Ykc5eVhDSTZYQ0lqWm1abVptWm1YQ0lzWENKamRYTjBiMjFjSWpwY0ltWnZiblF0ZDJWcFoyaDBPaUE0TURBN1hGeHVkR1Y0ZEMxMGNtRnVjMlp2Y20wNklIVndjR1Z5WTJGelpUdGNJbjBpTENJM0lqb2llMXdpYVdSY0lqbzNMRndpZEhsd1pWd2lPbHdpWTNWemRHOXRYQ0lzWENKamJHRnpjMDVoYldWY0lqcGNJbTF6Y0MxamJpMHhMVGRjSWl4Y0ltWnZiblJHWVcxcGJIbGNJanBjSWt4aGRHOWNJaXhjSW1admJuUlhaV2xuYUhSY0lqcGNJak13TUZ3aUxGd2labTl1ZEZOcGVtVmNJam96TUN4Y0lteHBibVZJWldsbmFIUmNJanBjSW01dmNtMWhiRndpTEZ3aVkyOXNiM0pjSWpwY0lpTm1abVptWm1aY0luMGlMQ0k0SWpvaWUxd2lhV1JjSWpvNExGd2labTl1ZEZkbGFXZG9kRndpT2x3aWJtOXliV0ZzWENJc1hDSnNhVzVsU0dWcFoyaDBYQ0k2WENKdWIzSnRZV3hjSW4waWZTd2lUVk5RWVc1bGJDNUZabVpsWTNRaU9uc2lNU0k2SW50Y0ltbGtYQ0k2WENJeFhDSXNYQ0ptWVdSbFhDSTZkSEoxWlN4Y0luUnlZVzV6YkdGMFpWcGNJam8xTURCOUlpd2lNaUk2SW50Y0ltbGtYQ0k2TWl4Y0ltWmhaR1ZjSWpwMGNuVmxmU0lzSWpNaU9pSjdYQ0pwWkZ3aU9qTXNYQ0ptWVdSbFhDSTZkSEoxWlN4Y0luUnlZVzV6YkdGMFpWcGNJam8xTURCOUlpd2lOQ0k2SW50Y0ltbGtYQ0k2TkN4Y0ltWmhaR1ZjSWpwMGNuVmxmU0lzSWpjaU9pSjdYQ0pwWkZ3aU9qY3NYQ0ptWVdSbFhDSTZkSEoxWlN4Y0luUnlZVzV6YkdGMFpWcGNJam8xTURCOUlpd2lPQ0k2SW50Y0ltbGtYQ0k2T0N4Y0ltWmhaR1ZjSWpwMGNuVmxmU0lzSWpraU9pSjdYQ0pwWkZ3aU9qa3NYQ0ptWVdSbFhDSTZkSEoxWlN4Y0luUnlZVzV6YkdGMFpWcGNJam90TlRBd2ZTSXNJakV3SWpvaWUxd2lhV1JjSWpveE1DeGNJbVpoWkdWY0lqcDBjblZsZlNJc0lqRXpJam9pZTF3aWFXUmNJam94TXl4Y0ltWmhaR1ZjSWpwMGNuVmxmU0lzSWpFMElqb2llMXdpYVdSY0lqb3hOQ3hjSW1aaFpHVmNJanAwY25WbGZTSXNJakUxSWpvaWUxd2lhV1JjSWpveE5TeGNJbVpoWkdWY0lqcDBjblZsZlNJc0lqRTJJam9pZTF3aWFXUmNJam94Tml4Y0ltWmhaR1ZjSWpwMGNuVmxmU0o5TENKTlUxQmhibVZzTGt4aGVXVnlJanA3SWpFaU9pSjdYQ0pwWkZ3aU9sd2lNVndpTEZ3aWJtRnRaVndpT2x3aWJHRjVaWEpjSWl4Y0ltbHpURzlqYTJWa1hDSTZabUZzYzJVc1hDSnBjMGhwWkdWa1hDSTZabUZzYzJVc1hDSnBjMU52Ykc5bFpGd2lPbVpoYkhObExGd2ljMmh2ZDFSeVlXNXpabTl5YlZ3aU9sd2ljR1Z5YzNCbFkzUnBkbVVvTWpBd01IQjRLU0IwY21GdWMyeGhkR1ZhS0RVd01IQjRLVndpTEZ3aWMyaHZkMDl5YVdkcGJsd2lPbHdpTlRBbElEVXdKU0F3Y0hoY0lpeGNJbk5vYjNkR1lXUmxYQ0k2ZEhKMVpTeGNJbWhwWkdWVWNtRnVjMlp2Y20xY0lqcGNJbHdpTEZ3aWFHbGtaVTl5YVdkcGJsd2lPbHdpWENJc1hDSm9hV1JsUm1Ga1pWd2lPblJ5ZFdVc1hDSnpkR0ZuWlU5bVpuTmxkRmhjSWpvd0xGd2ljM1JoWjJWUFptWnpaWFJaWENJNk1DeGNJbTl5WkdWeVhDSTZNQ3hjSW5SNWNHVmNJanBjSW5SbGVIUmNJaXhjSW5CdmMybDBhVzl1WENJNlhDSnViM0p0WVd4Y0lpeGNJbTV2VTNkcGNHVmNJanBtWVd4elpTeGNJbU52Ym5SbGJuUmNJanBjSWxkbElIQnliM1pwWkdVZ2RHaGxJR0psYzNSY0lpeGNJblpwWkdWdlhDSTZYQ0pvZEhSd09pOHZjR3hoZVdWeUxuWnBiV1Z2TG1OdmJTOTJhV1JsYnk4eE1UY3lNVEkwTWx3aUxGd2lZV3hwWjI1Y0lqcGNJblJ2Y0Z3aUxGd2lkWE5sUVdOMGFXOXVYQ0k2Wm1Gc2MyVXNYQ0p6WTNKdmJHeEVkWEpoZEdsdmJsd2lPaklzWENKdlptWnpaWFJZWENJNk1DeGNJbTltWm5ObGRGbGNJam90TXpZdU5TeGNJbkpsYzJsNlpWd2lPblJ5ZFdVc1hDSm1hWGhsWkZ3aU9tWmhiSE5sTEZ3aWQybGtkR2hzYVcxcGRGd2lPbHdpTUZ3aUxGd2liM0pwWjJsdVhDSTZYQ0p0WTF3aUxGd2ljM1JoZVVodmRtVnlYQ0k2ZEhKMVpTeGNJbU5zWVhOelRtRnRaVndpT2x3aWJYTndMV051TFRFdE1Wd2lMRndpYzJodmQwUjFjbUYwYVc5dVhDSTZNQzR6T0RjMUxGd2ljMmh2ZDBSbGJHRjVYQ0k2TUN4Y0luTm9iM2RGWVhObFhDSTZYQ0psWVhObFQzVjBVWFZwYm5SY0lpeGNJbk5vYjNkRlptWkdkVzVqWENJNlhDSjBLSFJ5ZFdVc2JpeHVMRFV3TUN4dUxHNHNiaXh1TEc0c2JpeHVMRzRzYml4dUxHNHBYQ0lzWENKMWMyVklhV1JsWENJNlptRnNjMlVzWENKb2FXUmxSSFZ5WVhScGIyNWNJam94TEZ3aWFHbGtaVVJsYkdGNVhDSTZNU3hjSW1ocFpHVkZZWE5sWENJNlhDSmxZWE5sVDNWMFVYVnBiblJjSWl4Y0ltSjBia05zWVhOelhDSTZYQ0p0Y3kxaWRHNGdiWE10WkdWbVlYVnNkQzFpZEc1Y0lpeGNJbk5zYVdSbFhDSTZYQ0l4WENJc1hDSnpkSGxzWlUxdlpHVnNYQ0k2WENJeFhDSXNYQ0p6YUc5M1JXWm1aV04wWENJNlhDSXhYQ0lzWENKb2FXUmxSV1ptWldOMFhDSTZNbjBpTENJeUlqb2llMXdpYVdSY0lqb3lMRndpYm1GdFpWd2lPbHdpYkdGNVpYSmNJaXhjSW1selRHOWphMlZrWENJNlptRnNjMlVzWENKcGMwaHBaR1ZrWENJNlptRnNjMlVzWENKcGMxTnZiRzlsWkZ3aU9tWmhiSE5sTEZ3aWMyaHZkMVJ5WVc1elptOXliVndpT2x3aWNHVnljM0JsWTNScGRtVW9NakF3TUhCNEtTQjBjbUZ1YzJ4aGRHVmFLRFV3TUhCNEtWd2lMRndpYzJodmQwOXlhV2RwYmx3aU9sd2lOVEFsSURVd0pTQXdjSGhjSWl4Y0luTm9iM2RHWVdSbFhDSTZkSEoxWlN4Y0ltaHBaR1ZVY21GdWMyWnZjbTFjSWpwY0lsd2lMRndpYUdsa1pVOXlhV2RwYmx3aU9sd2lYQ0lzWENKb2FXUmxSbUZrWlZ3aU9uUnlkV1VzWENKemRHRm5aVTltWm5ObGRGaGNJam93TEZ3aWMzUmhaMlZQWm1aelpYUlpYQ0k2TUN4Y0ltOXlaR1Z5WENJNk1TeGNJblI1Y0dWY0lqcGNJblJsZUhSY0lpeGNJbkJ2YzJsMGFXOXVYQ0k2WENKdWIzSnRZV3hjSWl4Y0ltNXZVM2RwY0dWY0lqcG1ZV3h6WlN4Y0ltTnZiblJsYm5SY0lqcGNJbGRsWkdScGJtZkNvRkJzWVc1dWFXNW5YQ0lzWENKMmFXUmxiMXdpT2x3aWFIUjBjRG92TDNCc1lYbGxjaTUyYVcxbGJ5NWpiMjB2ZG1sa1pXOHZNVEUzTWpFeU5ESmNJaXhjSW1Gc2FXZHVYQ0k2WENKMGIzQmNJaXhjSW5WelpVRmpkR2x2Ymx3aU9tWmhiSE5sTEZ3aWMyTnliMnhzUkhWeVlYUnBiMjVjSWpveUxGd2liMlptYzJWMFdGd2lPakV4Tmk0MUxGd2liMlptYzJWMFdWd2lPamczTEZ3aWNtVnphWHBsWENJNmRISjFaU3hjSW1acGVHVmtYQ0k2Wm1Gc2MyVXNYQ0ozYVdSMGFHeHBiV2wwWENJNlhDSXdYQ0lzWENKdmNtbG5hVzVjSWpwY0ltMXNYQ0lzWENKemRHRjVTRzkyWlhKY0lqcDBjblZsTEZ3aVkyeGhjM05PWVcxbFhDSTZYQ0p0YzNBdFkyNHRNUzB5WENJc1hDSnphRzkzUkhWeVlYUnBiMjVjSWpvd0xqTTROelVzWENKemFHOTNSR1ZzWVhsY0lqb3dMak00TnpVc1hDSnphRzkzUldGelpWd2lPbHdpWldGelpVOTFkRkYxYVc1MFhDSXNYQ0p6YUc5M1JXWm1SblZ1WTF3aU9sd2lkQ2gwY25WbExHNHNiaXcxTURBc2JpeHVMRzRzYml4dUxHNHNiaXh1TEc0c2JpeHVLVndpTEZ3aWRYTmxTR2xrWlZ3aU9tWmhiSE5sTEZ3aWFHbGtaVVIxY21GMGFXOXVYQ0k2TVN4Y0ltaHBaR1ZFWld4aGVWd2lPakVzWENKb2FXUmxSV0Z6WlZ3aU9sd2laV0Z6WlU5MWRGRjFhVzUwWENJc1hDSmlkRzVEYkdGemMxd2lPbHdpYlhNdFluUnVJRzF6TFdSbFptRjFiSFF0WW5SdVhDSXNYQ0p6Ykdsa1pWd2lPbHdpTVZ3aUxGd2ljM1I1YkdWTmIyUmxiRndpT2pJc1hDSnphRzkzUldabVpXTjBYQ0k2TXl4Y0ltaHBaR1ZGWm1abFkzUmNJam8wZlNJc0lqUWlPaUo3WENKcFpGd2lPalFzWENKdVlXMWxYQ0k2WENKc1lYbGxjbHdpTEZ3aWFYTk1iMk5yWldSY0lqcG1ZV3h6WlN4Y0ltbHpTR2xrWldSY0lqcG1ZV3h6WlN4Y0ltbHpVMjlzYjJWa1hDSTZabUZzYzJVc1hDSnphRzkzVkhKaGJuTm1iM0p0WENJNlhDSndaWEp6Y0dWamRHbDJaU2d5TURBd2NIZ3BJSFJ5WVc1emJHRjBaVm9vTlRBd2NIZ3BYQ0lzWENKemFHOTNUM0pwWjJsdVhDSTZYQ0kxTUNVZ05UQWxJREJ3ZUZ3aUxGd2ljMmh2ZDBaaFpHVmNJanAwY25WbExGd2lhR2xrWlZSeVlXNXpabTl5YlZ3aU9sd2lYQ0lzWENKb2FXUmxUM0pwWjJsdVhDSTZYQ0pjSWl4Y0ltaHBaR1ZHWVdSbFhDSTZkSEoxWlN4Y0luTjBZV2RsVDJabWMyVjBXRndpT2pBc1hDSnpkR0ZuWlU5bVpuTmxkRmxjSWpvd0xGd2liM0prWlhKY0lqb3hMRndpZEhsd1pWd2lPbHdpZEdWNGRGd2lMRndpY0c5emFYUnBiMjVjSWpwY0ltNXZjbTFoYkZ3aUxGd2libTlUZDJsd1pWd2lPbVpoYkhObExGd2lZMjl1ZEdWdWRGd2lPbHdpVUV4QlRrNUZVbHdpTEZ3aWRtbGtaVzljSWpwY0ltaDBkSEE2THk5d2JHRjVaWEl1ZG1sdFpXOHVZMjl0TDNacFpHVnZMekV4TnpJeE1qUXlYQ0lzWENKaGJHbG5ibHdpT2x3aWRHOXdYQ0lzWENKMWMyVkJZM1JwYjI1Y0lqcG1ZV3h6WlN4Y0luTmpjbTlzYkVSMWNtRjBhVzl1WENJNk1peGNJbTltWm5ObGRGaGNJam90T1N4Y0ltOW1abk5sZEZsY0lqb3hNQ3hjSW5KbGMybDZaVndpT25SeWRXVXNYQ0ptYVhobFpGd2lPbVpoYkhObExGd2lkMmxrZEdoc2FXMXBkRndpT2x3aU1Gd2lMRndpYjNKcFoybHVYQ0k2WENKdGJGd2lMRndpYzNSaGVVaHZkbVZ5WENJNmRISjFaU3hjSW1Oc1lYTnpUbUZ0WlZ3aU9sd2liWE53TFdOdUxURXRORndpTEZ3aWMyaHZkMFIxY21GMGFXOXVYQ0k2TUM0ek9EYzFMRndpYzJodmQwUmxiR0Y1WENJNk1DNDBNalVzWENKemFHOTNSV0Z6WlZ3aU9sd2laV0Z6WlU5MWRGRjFhVzUwWENJc1hDSnphRzkzUldabVJuVnVZMXdpT2x3aWRDaDBjblZsTEc0c2JpdzFNREFzYml4dUxHNHNiaXh1TEc0c2JpeHVMRzRzYml4dUtWd2lMRndpZFhObFNHbGtaVndpT21aaGJITmxMRndpYUdsa1pVUjFjbUYwYVc5dVhDSTZNU3hjSW1ocFpHVkVaV3hoZVZ3aU9qRXNYQ0pvYVdSbFJXRnpaVndpT2x3aVpXRnpaVTkxZEZGMWFXNTBYQ0lzWENKaWRHNURiR0Z6YzF3aU9sd2liWE10WW5SdUlHMXpMV1JsWm1GMWJIUXRZblJ1WENJc1hDSnpiR2xrWlZ3aU9tNTFiR3dzWENKemRIbHNaVTF2WkdWc1hDSTZOQ3hjSW5Ob2IzZEZabVpsWTNSY0lqbzNMRndpYUdsa1pVVm1abVZqZEZ3aU9qaDlJaXdpTlNJNkludGNJbWxrWENJNk5TeGNJbTVoYldWY0lqcGNJbXhoZVdWeVhDSXNYQ0pwYzB4dlkydGxaRndpT21aaGJITmxMRndpYVhOSWFXUmxaRndpT21aaGJITmxMRndpYVhOVGIyeHZaV1JjSWpwbVlXeHpaU3hjSW5Ob2IzZFVjbUZ1YzJadmNtMWNJanBjSW5CbGNuTndaV04wYVhabEtESXdNREJ3ZUNrZ2RISmhibk5zWVhSbFdpZ3ROVEF3Y0hncFhDSXNYQ0p6YUc5M1QzSnBaMmx1WENJNlhDSTFNQ1VnTlRBbElEQndlRndpTEZ3aWMyaHZkMFpoWkdWY0lqcDBjblZsTEZ3aWFHbGtaVlJ5WVc1elptOXliVndpT2x3aVhDSXNYQ0pvYVdSbFQzSnBaMmx1WENJNlhDSmNJaXhjSW1ocFpHVkdZV1JsWENJNmRISjFaU3hjSW5OMFlXZGxUMlptYzJWMFdGd2lPakFzWENKemRHRm5aVTltWm5ObGRGbGNJam93TEZ3aWIzSmtaWEpjSWpvd0xGd2lkSGx3WlZ3aU9sd2lkR1Y0ZEZ3aUxGd2ljRzl6YVhScGIyNWNJanBjSW01dmNtMWhiRndpTEZ3aWJtOVRkMmx3WlZ3aU9tWmhiSE5sTEZ3aVkyOXVkR1Z1ZEZ3aU9sd2lWMlZrWkdsdVoxd2lMRndpZG1sa1pXOWNJanBjSW1oMGRIQTZMeTl3YkdGNVpYSXVkbWx0Wlc4dVkyOXRMM1pwWkdWdkx6RXhOekl4TWpReVhDSXNYQ0poYkdsbmJsd2lPbHdpZEc5d1hDSXNYQ0oxYzJWQlkzUnBiMjVjSWpwbVlXeHpaU3hjSW5OamNtOXNiRVIxY21GMGFXOXVYQ0k2TWl4Y0ltOW1abk5sZEZoY0lqb3dMRndpYjJabWMyVjBXVndpT2kweE1ESXNYQ0p5WlhOcGVtVmNJanAwY25WbExGd2labWw0WldSY0lqcG1ZV3h6WlN4Y0luZHBaSFJvYkdsdGFYUmNJanBjSWpCY0lpeGNJbTl5YVdkcGJsd2lPbHdpYld4Y0lpeGNJbk4wWVhsSWIzWmxjbHdpT25SeWRXVXNYQ0pqYkdGemMwNWhiV1ZjSWpwY0ltMXpjQzFqYmkweExUVmNJaXhjSW5Ob2IzZEVkWEpoZEdsdmJsd2lPakF1TXpnM05TeGNJbk5vYjNkRVpXeGhlVndpT2pBc1hDSnphRzkzUldGelpWd2lPbHdpWldGelpVOTFkRkYxYVc1MFhDSXNYQ0p6YUc5M1JXWm1SblZ1WTF3aU9sd2lkQ2gwY25WbExHNHNiaXd0TlRBd0xHNHNiaXh1TEc0c2JpeHVMRzRzYml4dUxHNHNiaWxjSWl4Y0luVnpaVWhwWkdWY0lqcG1ZV3h6WlN4Y0ltaHBaR1ZFZFhKaGRHbHZibHdpT2pFc1hDSm9hV1JsUkdWc1lYbGNJam94TEZ3aWFHbGtaVVZoYzJWY0lqcGNJbVZoYzJWUGRYUlJkV2x1ZEZ3aUxGd2lZblJ1UTJ4aGMzTmNJanBjSW0xekxXSjBiaUJ0Y3kxa1pXWmhkV3gwTFdKMGJsd2lMRndpYzJ4cFpHVmNJanB1ZFd4c0xGd2ljM1I1YkdWTmIyUmxiRndpT2pVc1hDSnphRzkzUldabVpXTjBYQ0k2T1N4Y0ltaHBaR1ZGWm1abFkzUmNJam94TUgwaUxDSTNJam9pZTF3aWFXUmNJam8zTEZ3aWJtRnRaVndpT2x3aWJHRjVaWEpjSWl4Y0ltbHpURzlqYTJWa1hDSTZabUZzYzJVc1hDSnBjMGhwWkdWa1hDSTZabUZzYzJVc1hDSnBjMU52Ykc5bFpGd2lPbVpoYkhObExGd2ljMmh2ZDFSeVlXNXpabTl5YlZ3aU9sd2lYQ0lzWENKemFHOTNUM0pwWjJsdVhDSTZYQ0pjSWl4Y0luTm9iM2RHWVdSbFhDSTZkSEoxWlN4Y0ltaHBaR1ZVY21GdWMyWnZjbTFjSWpwY0lsd2lMRndpYUdsa1pVOXlhV2RwYmx3aU9sd2lYQ0lzWENKb2FXUmxSbUZrWlZ3aU9uUnlkV1VzWENKemRHRm5aVTltWm5ObGRGaGNJam93TEZ3aWMzUmhaMlZQWm1aelpYUlpYQ0k2TUN4Y0ltOXlaR1Z5WENJNk15eGNJblI1Y0dWY0lqcGNJblJsZUhSY0lpeGNJbkJ2YzJsMGFXOXVYQ0k2WENKdWIzSnRZV3hjSWl4Y0ltNXZVM2RwY0dWY0lqcG1ZV3h6WlN4Y0ltTnZiblJsYm5SY0lqcGNJa0o1SUZSdmRHRnNJRUoxYzJsdVpYTnpYQ0lzWENKMmFXUmxiMXdpT2x3aWFIUjBjRG92TDNCc1lYbGxjaTUyYVcxbGJ5NWpiMjB2ZG1sa1pXOHZNVEUzTWpFeU5ESmNJaXhjSW1Gc2FXZHVYQ0k2WENKMGIzQmNJaXhjSW5WelpVRmpkR2x2Ymx3aU9tWmhiSE5sTEZ3aWMyTnliMnhzUkhWeVlYUnBiMjVjSWpveUxGd2liMlptYzJWMFdGd2lPakFzWENKdlptWnpaWFJaWENJNk1UTTVMRndpY21WemFYcGxYQ0k2ZEhKMVpTeGNJbVpwZUdWa1hDSTZabUZzYzJVc1hDSjNhV1IwYUd4cGJXbDBYQ0k2WENJd1hDSXNYQ0p2Y21sbmFXNWNJanBjSW0xc1hDSXNYQ0p6ZEdGNVNHOTJaWEpjSWpwMGNuVmxMRndpWTJ4aGMzTk9ZVzFsWENJNlhDSnRjM0F0WTI0dE1TMDNYQ0lzWENKemFHOTNSSFZ5WVhScGIyNWNJam93TGpRMUxGd2ljMmh2ZDBSbGJHRjVYQ0k2TVM0ek5qSTFMRndpYzJodmQwVmhjMlZjSWpwY0ltVmhjMlZQZFhSUmRXbHVkRndpTEZ3aWRYTmxTR2xrWlZ3aU9tWmhiSE5sTEZ3aWFHbGtaVVIxY21GMGFXOXVYQ0k2TVN4Y0ltaHBaR1ZFWld4aGVWd2lPakVzWENKb2FXUmxSV0Z6WlZ3aU9sd2laV0Z6WlU5MWRGRjFhVzUwWENJc1hDSmlkRzVEYkdGemMxd2lPbHdpYlhNdFluUnVJRzF6TFdSbFptRjFiSFF0WW5SdVhDSXNYQ0p6Ykdsa1pWd2lPak1zWENKemRIbHNaVTF2WkdWc1hDSTZOeXhjSW5Ob2IzZEZabVpsWTNSY0lqb3hNeXhjSW1ocFpHVkZabVpsWTNSY0lqb3hOSDBpTENJNElqb2llMXdpYVdSY0lqbzRMRndpYm1GdFpWd2lPbHdpYkdGNVpYSmNJaXhjSW1selRHOWphMlZrWENJNlptRnNjMlVzWENKcGMwaHBaR1ZrWENJNlptRnNjMlVzWENKcGMxTnZiRzlsWkZ3aU9tWmhiSE5sTEZ3aWMyaHZkMVJ5WVc1elptOXliVndpT2x3aVhDSXNYQ0p6YUc5M1QzSnBaMmx1WENJNlhDSmNJaXhjSW5Ob2IzZEdZV1JsWENJNmRISjFaU3hjSW1ocFpHVlVjbUZ1YzJadmNtMWNJanBjSWx3aUxGd2lhR2xrWlU5eWFXZHBibHdpT2x3aVhDSXNYQ0pvYVdSbFJtRmtaVndpT25SeWRXVXNYQ0pwYldkVWFIVnRZbHdpT2x3aUx6SXdNVFV2TURrdmMyeHBaR1Z5TFRFdFpHbDJhV1JsY2k1cWNHZGNJaXhjSW5OMFlXZGxUMlptYzJWMFdGd2lPakFzWENKemRHRm5aVTltWm5ObGRGbGNJam93TEZ3aWIzSmtaWEpjSWpveUxGd2lkSGx3WlZ3aU9sd2lhVzFoWjJWY0lpeGNJbkJ2YzJsMGFXOXVYQ0k2WENKdWIzSnRZV3hjSWl4Y0ltNXZVM2RwY0dWY0lqcG1ZV3h6WlN4Y0ltTnZiblJsYm5SY0lqcGNJa3h2Y21WdElFbHdjM1Z0WENJc1hDSnBiV2RjSWpwY0lpOHlNREUxTHpBNUwzTnNhV1JsY2kweExXUnBkbWxrWlhJdWFuQm5YQ0lzWENKMmFXUmxiMXdpT2x3aWFIUjBjRG92TDNCc1lYbGxjaTUyYVcxbGJ5NWpiMjB2ZG1sa1pXOHZNVEUzTWpFeU5ESmNJaXhjSW1Gc2FXZHVYQ0k2WENKMGIzQmNJaXhjSW5WelpVRmpkR2x2Ymx3aU9tWmhiSE5sTEZ3aWMyTnliMnhzUkhWeVlYUnBiMjVjSWpveUxGd2liMlptYzJWMFdGd2lPakFzWENKdlptWnpaWFJaWENJNk9EY3NYQ0p5WlhOcGVtVmNJanAwY25WbExGd2labWw0WldSY0lqcG1ZV3h6WlN4Y0luZHBaSFJvYkdsdGFYUmNJanBjSWpCY0lpeGNJbTl5YVdkcGJsd2lPbHdpYld4Y0lpeGNJbk4wWVhsSWIzWmxjbHdpT25SeWRXVXNYQ0p6YUc5M1JIVnlZWFJwYjI1Y0lqb3dMalF6TnpVc1hDSnphRzkzUkdWc1lYbGNJam93TGpreE1qVXNYQ0p6YUc5M1JXRnpaVndpT2x3aVpXRnpaVTkxZEZGMWFXNTBYQ0lzWENKMWMyVklhV1JsWENJNlptRnNjMlVzWENKb2FXUmxSSFZ5WVhScGIyNWNJam94TEZ3aWFHbGtaVVJsYkdGNVhDSTZNU3hjSW1ocFpHVkZZWE5sWENJNlhDSmxZWE5sVDNWMFVYVnBiblJjSWl4Y0ltSjBia05zWVhOelhDSTZYQ0p0Y3kxaWRHNGdiWE10WkdWbVlYVnNkQzFpZEc1Y0lpeGNJbk5zYVdSbFhDSTZNeXhjSW5OMGVXeGxUVzlrWld4Y0lqbzRMRndpYzJodmQwVm1abVZqZEZ3aU9qRTFMRndpYUdsa1pVVm1abVZqZEZ3aU9qRTJmU0o5ZlE9PSIsInR5cGUiOiJjdXN0b20iLCJzbGlkZXNfbnVtIjoiMiJ9fSwib3JpZ2luX3VwbG9hZHNfdXJsIjoiaHR0cDpcL1wvZGVtby5nb29kbGF5ZXJzLmNvbVwvdG90YWxidXNpbmVzc1wvd2VkZGluZ3BsYW5uZXJcL3dwLWNvbnRlbnRcL3VwbG9hZHMiLCJwcmVzZXRfc3R5bGVzIjoiZXlKdFpYUmhJanA3ZlgwPSIsInByZXNldF9lZmZlY3RzIjoiIn0=',
					'screenshot'=> get_template_directory_uri() . '/images/sample-slider.png',
					'selected' => false
				),
				array(
					'label'     => esc_html__( 'Sample Slider Wood', 'totalbusiness' ),
					'id'        => 'totalbusiness-sample-slider9',
					'slidertype'=> 'custom',
					'importdata'=> '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',
					'screenshot'=> get_template_directory_uri() . '/images/sample-slider.png',
					'selected' => false
				),
			);
			
			return $starters;
		}
	}
    	
	
	
	// page item section
	if(!function_exists('totalbusiness_get_masterslider_list')){
		function totalbusiness_get_masterslider_list(){
			if( !function_exists('get_masterslider_names') ) return;
		
			return get_masterslider_names(true);
		}
	}
	
	add_action('totalbusiness_print_item_selector', 'totalbusiness_check_masterslider_item', 10, 2);
	if( !function_exists('totalbusiness_check_masterslider_item') ){
		function totalbusiness_check_masterslider_item( $type, $settings = array() ){
			if( !function_exists('get_masterslider') ) return;
		
			$item_id = empty($settings['page-item-id'])? '': ' id="' . $settings['page-item-id'] . '" ';

			global $totalbusiness_spaces;
			$margin = (!empty($settings['margin-bottom']) && 
				$settings['margin-bottom'] != $totalbusiness_spaces['bottom-item'])? 'margin-bottom: ' . $settings['margin-bottom'] . ';': '';
			$margin_style = (!empty($margin))? ' style="' . $margin . '" ': '';	
		
			if($type == 'master-slider'){
				echo '<div class="totalbusiness-master-slider-item totalbusiness-slider-item totalbusiness-item" ' . $item_id . $margin_style . ' >';
				echo get_masterslider($settings['id']);
				echo '</div>';
			}
		}
	}	
	
?>